-- the time that is allowed to elapse from automatic dismount to remount. set to nil / 0 to disable this check.
SIMPLEMOUNT_TIMEOUT = 30;

-- how much time to allow the user to loot
SIMPLEMOUNT_TIME_AFTER_LOOT = 1;

-- how much time to allow the user to loot when using a "multiple" gathering skill (i.e. Mining).
SIMPLEMOUNT_TIME_AFTER_LOOT_MULTIPLE = 3;

-- time between updates
SIMPLEMOUNT_TIME_BETWEEN_UPDATES = 0.1;

SIMPLEMOUNT_MAILBOXTIMEOUT = 0.5;


-- maximum time to wait after combat has stopped
SIMPLEMOUNT_COMBATTIMEOUT = 5;

SIMPLEMOUNT_MODE_DOMOUNT = 1;
SIMPLEMOUNT_MODE_DOMAILBOXCHECK = 2;
SIMPLEMOUNT_MODE_DOCOMBATLOOTCHECK = 3;



SimpleMount_ShouldMountAt = nil;

SimpleMount_Saved_GameTooltip_Show = nil;
SimpleMount_Saved_GameTooltip_OnHide = nil;
SimpleMount_LastShownTooltip = nil;
SimpleMount_LastHiddenTooltip = nil;
SimpleMount_LastCombatStopped = nil;
SimpleMount_TooltipStrings = {};

SimpleMount_HandledItem = nil;
SimpleMount_LastDismount = nil;
SimpleMount_HasMining = false;
SimpleMount_HasHerbalism = false;
SimpleMount_HasSkinning = false;
SimpleMount_LastMailboxHidden = nil;

SimpleMount_Options_Default = {
	["enabled"] = true,
	["handleGathering"] = true,
	["handleMailbox"] = true,
	["remountWhenClosingMailbox"] = true,
	["remountWithMailboxOpen"] = true,
	["gatheringRemountTimeout"] = SIMPLEMOUNT_TIMEOUT,
	["timeAfterLoot"] = SIMPLEMOUNT_TIME_AFTER_LOOT,
	["timeAfterLootMultiple"] = SIMPLEMOUNT_TIME_AFTER_LOOT_MULTIPLE,
	["mountAfterCombat"] = false,
	["timeToMountAfterCombat"] = SIMPLEMOUNT_COMBATTIMEOUT
};

SimpleMount_Options = SimpleMount_Options_Default;


SimpleMount_HasAcknowledged = false;

function SimpleMount_CheckAcknowledgement()
	if ( not SimpleMount_HasAcknowledged ) and ( not SimpleMount_Options.ignoreClass ) and ( SIMPLEMOUNT_CLASS_TABLE[UnitClass("player")] ) then
		for k, line in SIMPLEMOUNT_ERROR_CAN_NOT_SUMMON_MOUNT do
			AddOnHelper_Print(line, 1, 0.2, 0.2);
		end
		return false;
	end
	return true;
end

function SimpleMount_OnLoad()
	SimpleMount_Options_OnLoad();
	
	SimpleMount_Saved_GameTooltip_Show = GameTooltip.Show;
	GameTooltip.Show = SimpleMount_GameTooltip_Show;
	SimpleMount_Saved_GameTooltip_OnHide = GameTooltip_OnHide;
	GameTooltip_OnHide = SimpleMount_GameTooltip_OnHide;

	local f = SimpleMountFrame;
	f:RegisterEvent("VARIABLES_LOADED");
	f:RegisterEvent("SPELLS_CHANGED");
	f:RegisterEvent("CHAT_MSG_SPELL_SELF_BUFF");
	f:RegisterEvent("UI_ERROR_MESSAGE");
	f:RegisterEvent("MAIL_SHOW");
	f:RegisterEvent("MAIL_CLOSED");
	f:RegisterEvent("PLAYER_LEAVE_COMBAT");
	f:RegisterEvent("LOOT_OPENED");
	SimpleMount_CheckAcknowledgement();
end

function SimpleMount_InStealth(state)
	local buff = nil;
	for i = 0, 15 do
		buff = GetPlayerBuffTexture(i);
		if ( buff ) and ( buff == "Interface\\Icons\\Ability_Stealth" ) then
			return true;
		end
	end
	return false;
end

function SimpleMount_OnEvent(event)
	if ( event == "VARIABLES_LOADED" ) then
		SimpleMount_SetupGatheringSkills();
		SimpleMountFrame:UnregisterEvent(event);
		for k, v in SimpleMount_Options_Default do
			if ( SimpleMount_Options[k] == nil ) then
				SimpleMount_Options[k] = v;
			end
		end
	end
	if ( event == "SPELLS_CHANGED" ) then
		SimpleMount_SetupGatheringSkills();
	end
	if ( event == "CHAT_MSG_SPELL_SELF_BUFF" ) then
		SimpleMount_HandlePerformChat(arg1);
	end
	if ( event == "MAIL_CLOSED" ) then
		if ( SimpleMount_Options.enabled ) and ( SimpleMount_Options.handleMailbox ) then
			if ( SimpleMount_Options.remountWhenClosingMailbox ) then
				if ( not MailFrame:IsVisible() ) then
					SimpleMount_Mount();
				end
			end
		end
	end
	if ( event == "MAIL_SHOW" ) then
		if ( SimpleMount_Options.enabled ) and ( SimpleMount_Options.handleMailbox ) then
			if ( SimpleMount_Options.remountWithMailboxOpen ) then
				SimpleMount_Mount();
			end
		end
	end
	if ( event == "UI_ERROR_MESSAGE" ) then
		if ( arg1 == SPELL_FAILED_NOT_MOUNTED ) then
			if ( not UnitOnTaxi("player") ) then
				SimpleMount_Dismount();
			end
		end
	end
	if ( event == "PLAYER_LEAVE_COMBAT" ) then
		SimpleMount_MountAfterCombat();
	end
	if ( event == "LOOT_OPENED" ) then
		-- TODO: add gathering check here too? hmm... not necessary tho
		if ( SimpleMount_Mode == SIMPLEMOUNT_MODE_DOCOMBATLOOTCHECK ) then
			SimpleMount_ShouldMountAt = GetTime() + 1;
			SimpleMount_SetMode(SIMPLEMOUNT_MODE_DOMOUNT);
		end
	end
end

function SimpleMount_MountAfterCombat()
	if ( SimpleMount_Options.enabled ) and ( SimpleMount_Options.mountAfterCombat ) and ( not SimpleMount_InStealth() ) then
		local mountBuffPos = AutoMount_GetMountBuffPosition();
		if ( mountBuffPos > -1 ) then
			return true;
		end
		SimpleMount_LastCombatStopped = GetTime();
		SimpleMount_SetMode(SIMPLEMOUNT_MODE_DOCOMBATLOOTCHECK);
	end
end


SimpleMount_TooltipTextLeftNames = {
	[1] = "GameTooltipTextLeft1",
	[2] = "GameTooltipTextLeft2",
	[3] = "GameTooltipTextLeft3",
	[4] = "GameTooltipTextLeft4",
};

function SimpleMount_GameTooltip_Show(tooltip)
	if ( SimpleMount_Options.enabled ) and ( tooltip == GameTooltip ) then
		local curTime = GetTime();
		local obj = nil;
		for k, v in SimpleMount_TooltipTextLeftNames do
			obj = getglobal(v);
			if ( obj ) then
				SimpleMount_TooltipStrings[k] = obj:GetText();
			end
		end
		SimpleMount_LastShownTooltip = curTime;
	end
	SimpleMount_Saved_GameTooltip_Show(tooltip);
end

SimpleMount_GameTooltip_OnHide_OldText = nil;

function SimpleMount_GameTooltip_OnHide(tooltip)
	if ( not SimpleMount_Options.enabled ) then
	end
	SimpleMount_Saved_GameTooltip_OnHide(tooltip);
end

function SimpleMount_HandlePerformed(action)
	if ( not SimpleMount_Options.enabled ) then
		return false;
	end
	if ( not SimpleMount_LastDismount ) and ( ( not SimpleMount_Options.gatheringRemountTimeout ) or ( SimpleMount_Options.gatheringRemountTimeout > 0 ) ) then
		return false;
	end
	if ( not action ) then
		return false;
	end
	local ok = false;
	for k, v in SimpleMount_Chat_SkillNames do
		if ( v == action ) then
			ok = true;
		end
	end
	if ( not ok ) then
		return false;
	end
	local n = tonumber(SimpleMount_Options.gatheringRemountTimeout);
	if ( n ) then
		if ( not SimpleMount_LastDismount ) or ( GetTime() - n > SIMPLEMOUNT_TIMEOUT ) then
			return false;
		end
	end
	
	-- fix for mining
	local addTime = tonumber(SimpleMount_Options.timeAfterLoot);
	for k, v in SimpleMount_SkillNames_Multiple do
		if ( v == action ) then
			addTime = tonumber(SimpleMount_Options.timeAfterLootMultiple);
			break;
		end
	end
	if ( not addTime ) then
		addTime = 1;
	end
	if ( SimpleMount_LastDismount ) then
		SimpleMount_LastDismount = SimpleMount_LastDismount + addTime;
	end
	SimpleMount_ShouldMountAt = GetTime() + addTime;
	SimpleMount_SetMode(SIMPLEMOUNT_MODE_DOMOUNT);
	return true;
end

function SimpleMount_HandlePerformChat(msg)
	if ( not SimpleMount_Options.enabled ) then
		return false;
	end
	if ( not SimpleMount_Options.handleGathering ) then
		return false;
	end
	local pattern = nil;
	local index = nil;
	for k, v in SimpleMount_Chat_PerformPatterns do
		pattern = v.pattern;
		index = v.actionIndex;
		for p1, p2, p3 in string.gfind(msg, pattern) do
			if ( index == 1 ) then
				SimpleMount_HandlePerformed(p1);
			elseif ( index == 2 ) then
				SimpleMount_HandlePerformed(p2);
			elseif ( index == 3 ) then
				SimpleMount_HandlePerformed(p3);
			end
		end
	end
end


function SimpleMount_SetupGatheringSkills()
	local spellName = nil;
	SimpleMount_HasMining = false;
	SimpleMount_HasHerbalism = false;
	SimpleMount_HasSkinning = false;
	for i = 1, 150 do
		spellName = GetSpellName(i, "spell");
		if ( not spellName ) then
			break;
		end
		if ( spellName == SimpleMount_Skill_Mining ) then
			SimpleMount_HasMining = true;
		end
		if ( spellName == SimpleMount_Skill_Herbalism ) then
			SimpleMount_HasHerbalism = true;
		end
		if ( spellName == SimpleMount_Skill_Skinning ) then
			SimpleMount_HasSkinning = true;
		end
	end
	SimpleMount_SetupDismountableStrings();
end

function SimpleMount_SetupDismountableStrings()
	SimpleMount_DismountableStrings = {};
	if ( SimpleMount_HasMining ) then
		for k, v in SimpleMount_DismountableStringsMining do
			table.insert(SimpleMount_DismountableStrings, v);
		end
	end
	if ( SimpleMount_HasHerbalism ) then
		for k, v in SimpleMount_DismountableStringsHerbalism do
			table.insert(SimpleMount_DismountableStrings, v);
		end
	end
	for k, v in SimpleMount_DismountableStringsOther do
		table.insert(SimpleMount_DismountableStrings, v);
	end
end

function SimpleMount_FixMount()
	if ( not SimpleMount_Options.enabled ) then
		return false;
	end
	if ( UnitOnTaxi("player") ) then
		return false;
	end
	local curTime = GetTime();
	if ( not SimpleMount_LastShownTooltip ) or ( curTime - SimpleMount_LastShownTooltip > 1 ) then
		return false;
	end
	SimpleMount_LastShownTooltip = nil;
	return SimpleMount_CheckTooltipAndDismount();
end

function SimpleMount_Dismount(mountBuffPos, itemName)
	if ( not mountBuffPos ) then
		mountBuffPos = AutoMount_GetMountBuffPosition();
	end
	if ( mountBuffPos <= -1 ) then
		return false;
	end
	if ( itemName ) then
		SimpleMount_HandledItem = itemName;
	end
	CancelPlayerBuff(mountBuffPos);
	SimpleMount_LastDismount = GetTime();
	return true;
end

function SimpleMount_CheckTooltipAndDismount()
	if ( not SimpleMount_Options.enabled ) then
		return false;
	end
	if ( UnitOnTaxi("player") ) then
		return false;
	end
	local mountBuffPos = AutoMount_GetMountBuffPosition();
	if ( mountBuffPos > -1 ) then
		local obj = nil;
		if ( SimpleMount_HasSkinning ) then
			local msg = nil;
			for i = 3, 4 do
				msg = SimpleMount_TooltipStrings[i];
				if ( msg ) and ( strlen(msg) > 0 ) then
					for k, v in SimpleMount_DismountableStringsSkinning do
						SimpleMount_Dismount(mountBuffPos, v);
						return true;
					end
				end
			end
		end
		local msg = SimpleMount_TooltipStrings[1];
		if ( msg ) and ( strlen(msg) > 0 ) then
			for k, v in SimpleMount_DismountableStrings do
				if ( string.find(msg, v) ) then
					SimpleMount_Dismount(mountBuffPos, v);
					return true;
				end
			end
		end
	end
	return false;
end

SimpleMount_Mount_Spell_Identifier = "MountSpell";


function SimpleMount_Mount_Spell()
	if ( ActionQueue_FindSpellId ) and ( ActionQueue_QueueSpell ) and ( ActionQueue_IsQueued ) then
		if ( ActionQueue_IsQueued(SimpleMount_Mount_Spell_Identifier) ) then
			return true;
		end
		local spells = SIMPLEMOUNT_CLASS_TABLE[UnitClass("player")];
		local spellId = nil;
		for k, v in spells do
			spellId = ActionQueue_FindSpellId(v);
		end
		if ( spellId ) and ( spellId > -1 ) then
			return ActionQueue_QueueSpell(spellId, nil, nil, nil, {id=SimpleMount_Mount_Spell_Identifier,priority=ACTIONQUEUE_HIGHEST_PRIORITY});
		end
	end
	return false;
end

function SimpleMount_Mount()
	local mountBuffPos = AutoMount_GetMountBuffPosition();
	if ( mountBuffPos > -1 ) then
		return true;
	end
	if ( not SimpleMount_Options.enabled ) then
		return false;
	end
	if ( PlayerFrame.inCombat ) then
		return false;
	end
	if ( UnitLevel("player") < 40 ) then
		return false;
	end
	if ( SIMPLEMOUNT_CLASS_TABLE[UnitClass("player")] ) and ( SimpleMount_Options.allowSummon ) then
		return SimpleMount_Mount_Spell();
	end
	
	local bag, slot = AutoMount_GetMountItemBagSlot();
	if ( not bag ) or ( not slot ) then
		return false;
	end
	UseContainerItem(bag, slot);
	return true;
end

SimpleMount_Mode = 0;
SimpleMount_LastUpdate = 0;

function SimpleMount_SetMode(mode)
	SimpleMount_Mode = mode;
	if ( mode <= 0 ) then
		SimpleMountFrame:Hide();
	else
		SimpleMountFrame:Show();
	end
end

function SimpleMount_OnUpdate(arg1)
	if ( not SimpleMount_Options.enabled ) then
		SimpleMountFrame:Hide();
		return false;
	end
	local curTime = GetTime();
	local diff = curTime - SimpleMount_LastUpdate;
	if ( diff < SIMPLEMOUNT_TIME_BETWEEN_UPDATES ) then
		return false;
	end
	SimpleMount_LastUpdate = curTime;
	if ( SimpleMount_Mode == SIMPLEMOUNT_MODE_DOMOUNT ) then
		if ( SimpleMount_ShouldMountAt ) then
			if ( not LootFrame:IsVisible() ) then
				if ( curTime >= SimpleMount_ShouldMountAt ) then
					SimpleMount_Mount();
					SimpleMount_ShouldMountAt = nil;
					SimpleMountFrame:Hide();
				end
			end
		else
			SimpleMountFrame:Hide();
		end
	elseif ( SimpleMount_Mode == SIMPLEMOUNT_MODE_DOMAILBOXCHECK ) then
		local isVisible = MailFrame:IsVisible();
		if ( isVisible ) or ( not SimpleMount_LastMailboxHidden ) then
			SimpleMount_LastMailboxHidden = nil;
			SimpleMountFrame:Hide();
		else
			if ( curTime - SimpleMount_LastMailboxHidden > tonumber(SimpleMount_Options.mailboxTooltipTimeout)) then
				local mountBuffPos = AutoMount_GetMountBuffPosition();
				if ( mountBuffPos > -1 ) then
					SimpleMount_Dismount(mountBuffPos, SimpleMount_DismountableStringsMailbox);
				end
				SimpleMount_LastMailboxHidden = nil;
				SimpleMountFrame:Hide();
			end
		end
	elseif ( SimpleMount_Mode == SIMPLEMOUNT_MODE_DOCOMBATLOOTCHECK ) then
		if ( PlayerFrame.inCombat ) or ( not SimpleMount_LastCombatStopped ) then
			SimpleMountFrame:Hide();
			return;
		end
		local isVisible = LootFrame:IsVisible();
		if ( isVisible ) then
			SimpleMount_ShouldMountAt = GetTime() + 1;
			SimpleMount_SetMode(SIMPLEMOUNT_MODE_DOMOUNT);
		else
			if ( curTime - SimpleMount_LastCombatStopped > tonumber(SimpleMount_Options.timeToMountAfterCombat)) then
				SimpleMount_Mount();
				local mountBuffPos = AutoMount_GetMountBuffPosition();
				if ( mountBuffPos > -1 ) then
					SimpleMount_Dismount(mountBuffPos, SimpleMount_DismountableStringsMailbox);
				end
				SimpleMount_LastMailboxHidden = nil;
				SimpleMountFrame:Hide();
			end
		end
	else
		SimpleMountFrame:Hide();
	end
end