
BINDING_HEADER_SIMPLEMOUNTHEADER		= "SimpleMount";
BINDING_NAME_TOGGLE_MOUNT				= "Toggle mount";

SIMPLEMOUNT_CLASS_PALADIN = "Paladin";
SIMPLEMOUNT_CLASS_WARLOCK = "Warlock";
SIMPLEMOUNT_CLASS_TABLE = {};
SIMPLEMOUNT_CLASS_TABLE[SIMPLEMOUNT_CLASS_PALADIN] = {"Summon Charger", "Summon Warhorse"};
SIMPLEMOUNT_CLASS_TABLE[SIMPLEMOUNT_CLASS_WARLOCK] = {"Summon Dreadsteed", "Summon Warhorse"};

SimpleMount_Skill_Herbalism = "Find Herbs";
SimpleMount_Skill_Mining = "Find Minerals";
SimpleMount_Skill_Skinning = "Skinning";

SimpleMount_Chat_PerformPatterns = {
	{ 
		["pattern"] = "You perform (.+) on (.+).",
		["actionIndex"] = 1
	},
}

SimpleMount_SkillNames_Multiple = {
	"Mining",
};

SimpleMount_Chat_SkillNames = {
	"Opening",
	"Herb Gathering",
	"Mining",
	"Skinning",
};


SimpleMount_DismountableStringsSkinning = {
	"Skinnable",
};

SimpleMount_DismountableStringsMining = {
	"Copper",
	"Tin",
	"Iron",
	"Silver",
	"Truesilver",
	"Gold",
	"Mithril",
	"Thorium",
};

SimpleMount_DismountableStringsHerbalism = {
	-- herb types 
	"Arthas' Tears",
	"Black Lotus",
	"Blindweed",
	"Briarthorn",
	"Bruiseweed",
	"Dreamfoil",
	"Earthroot",
	"Fadeleaf",
	"Firebloom",
	"Ghost Mushroom",
	"Golden Sansam",
	"Goldthorn",
	"Grave Moss",
	"Gromsblood",
	"Icecap",
	"Khadgar's Whisker",
	"Kingsblood",
	"Liferoot",
	"Mageroyal",
	"Mountain Silversage",
	"Peacebloom",
	"Plaguebloom",
	"Purple Lotus",
	"Silverleaf",
	"Stranglekelp",
	"Sungrass",
	"Swiftthistle",
	"Wild Steelbloom",
	"Wintersbite",
	"Wildvine",
};

SimpleMount_DismountableStringsOther = {
	"Box",
	"Chest",
	"Giant Clam",
	"Crate",
	"Barrel",
	"Cask",
	"Power Crystal",
};

SimpleMount_DismountableStringsMailbox = "Mailbox";

SimpleMount_DismountableStrings = {
	
};



-- SimpleMount options

--- Commandline

SIMPLEMOUNT_OPTIONS_CMD								= {"/simplemount", "/simplem", "/smount", "/sm"};
SIMPLEMOUNT_OPTIONS_CMD_DESC						= "controls SimpleMount AddOn";

SIMPLEMOUNT_CMD_ACKNOWLEDGE							= "acknowledge";
SIMPLEMOUNT_CMD_ACKNOWLEDGE_OPT_PERM				= "permanently";
SIMPLEMOUNT_CMD_ACKNOWLEDGE_OPT_EXPLAIN				= "explain";
SIMPLEMOUNT_CHAT_ACKNOWLEDGED						= "SimpleMount has had its limitations acknowledged.";
SIMPLEMOUNT_CHAT_ACKNOWLEDGED_PERM					= "SimpleMount has had its limitations acknowledged permanently.";
SIMPLEMOUNT_ERROR_CAN_NOT_SUMMON_MOUNT				= { 
	"SimpleMount can not summon mounts, which means that most Paladins and Warlocks will not be able to use it.",
	"Use /simplemount "..SIMPLEMOUNT_CMD_ACKNOWLEDGE.." to acknowledge this and access SimpleMount.",
	"Add the option "..SIMPLEMOUNT_CMD_ACKNOWLEDGE_OPT_PERM.." to make this acknowledgement permanent.",
	"Add the option "..SIMPLEMOUNT_CMD_ACKNOWLEDGE_OPT_EXPLAIN.." to explain why."
};
SIMPLEMOUNT_CHAT_ACKNOWLEDGE_EXPLAIN				= {
	"SimpleMount can not summon mounts because summoning - unlike using an item such as a mount - requires a key to be pressed.",
	"This is due to the way Blizzard prevented the autocasting way back when.",
	"While there are ways around it - check out ActionQueue - all of them requires that the user somehow presses a key."
};


SIMPLEMOUNT_OPTIONS_SLASH_CMDS						= {};
SIMPLEMOUNT_OPTIONS_SLASH_CMDS["help"]				= {"help"};
SIMPLEMOUNT_OPTIONS_SLASH_CMDS["toggle"]			= {"toggle", "tg", "t"};
SIMPLEMOUNT_OPTIONS_SLASH_CMDS["enable"]			= {"enable", "en", "e"};
SIMPLEMOUNT_OPTIONS_SLASH_CMDS["disable"]			= {"disable", "di", "d"};
SIMPLEMOUNT_OPTIONS_SLASH_CMDS["set"]				= {"set"};

SIMPLEMOUNT_OPTIONS_SLASH_FEAT						= {};
SIMPLEMOUNT_OPTIONS_SLASH_FEAT["main"]				= {"", "main"};
SIMPLEMOUNT_OPTIONS_SLASH_FEAT["summon"]			= {"summon", "allowsummon"};
SIMPLEMOUNT_OPTIONS_SLASH_FEAT["gathering"]			= {"gather", "gathering"};
SIMPLEMOUNT_OPTIONS_SLASH_FEAT["mailbox"]			= {"mailbox", "mb"};
SIMPLEMOUNT_OPTIONS_SLASH_FEAT["mailboxopen"]		= {"mailboxopen", "mbo"};
SIMPLEMOUNT_OPTIONS_SLASH_FEAT["mailboxclose"]		= {"mailboxclose", "mbc"};
SIMPLEMOUNT_OPTIONS_SLASH_FEAT["combat"]			= {"combat", "cb"};
SIMPLEMOUNT_OPTIONS_SLASH_FEAT["combattimeout"]		= {"combattimeout", "cbt"};
SIMPLEMOUNT_OPTIONS_SLASH_FEAT["loottimeout"]		= {"loottimeout", "lto"};
SIMPLEMOUNT_OPTIONS_SLASH_FEAT["lootmulttimeout"]	= {"lootmulttimeout", "lmto"};
SIMPLEMOUNT_OPTIONS_SLASH_FEAT["gatheringtimeout"]	= {"gatheringtimeout", "gto"};

-- provides a mapping between feature and SimpleMount_Options index (as well as Khaos index)
SIMPLEMOUNT_FEAT_OPTIONS_MAP						= {};
SIMPLEMOUNT_FEAT_OPTIONS_MAP["main"]				= "enabled";
SIMPLEMOUNT_FEAT_OPTIONS_MAP["summon"]				= "allowSummon";
SIMPLEMOUNT_FEAT_OPTIONS_MAP["gathering"]			= "handleGathering";
SIMPLEMOUNT_FEAT_OPTIONS_MAP["mailbox"]				= "handleMailbox";
SIMPLEMOUNT_FEAT_OPTIONS_MAP["mailboxopen"]			= "remountWithMailboxOpen";
SIMPLEMOUNT_FEAT_OPTIONS_MAP["mailboxclose"]		= "remountWhenClosingMailbox";
SIMPLEMOUNT_FEAT_OPTIONS_MAP["combat"]				= "mountAfterCombat";
SIMPLEMOUNT_FEAT_OPTIONS_MAP["combattimeout"]		= "timeToMountAfterCombat";
SIMPLEMOUNT_FEAT_OPTIONS_MAP["loottimeout"]			= "timeAfterLoot";
SIMPLEMOUNT_FEAT_OPTIONS_MAP["lootmulttimeout"]		= "timeAfterLootMultiple";
SIMPLEMOUNT_FEAT_OPTIONS_MAP["gatheringtimeout"]	= "gatheringRemountTimeout";

-- provides a mapping between feature and Cosmos name
SIMPLEMOUNT_FEAT_COSMOS_MAP							= {};
SIMPLEMOUNT_FEAT_COSMOS_MAP["main"]					= "COS_SIMPLEMOUNT_ENABLED";
SIMPLEMOUNT_FEAT_COSMOS_MAP["gathering"]			= "COS_SIMPLEMOUNT_GATHERING";
SIMPLEMOUNT_FEAT_COSMOS_MAP["mailbox"]				= "COS_SIMPLEMOUNT_MAILBOX";
SIMPLEMOUNT_FEAT_COSMOS_MAP["combat"]				= "COS_SIMPLEMOUNT_COMBAT";


SIMPLEMOUNT_SET_FEAT_VALID_VALUE					= {};
SIMPLEMOUNT_SET_FEAT_VALID_VALUE["toggle"]			= -1;
SIMPLEMOUNT_SET_FEAT_VALID_VALUE["enable"]			= 1;
SIMPLEMOUNT_SET_FEAT_VALID_VALUE["disable"]			= 0;

SIMPLEMOUNT_CMD_FEAT_VALID							= {};
SIMPLEMOUNT_CMD_FEAT_VALID["toggle"]				= {"main", "gathering", "mailbox", "mailboxopen", "mailboxclose", "combat", "summon"};
SIMPLEMOUNT_CMD_FEAT_VALID["enable"]				= SIMPLEMOUNT_CMD_FEAT_VALID["toggle"];
SIMPLEMOUNT_CMD_FEAT_VALID["disable"]				= SIMPLEMOUNT_CMD_FEAT_VALID["toggle"];
SIMPLEMOUNT_CMD_FEAT_VALID["set"]					= {"combattimeout", "loottimeout", "lootmulttimeout", "gatheringtimeout"};

SIMPLEMOUNT_ERROR_ILLEGAL_FEAT						= "SimpleMount: the feature you specified does not exist.";
SIMPLEMOUNT_ERROR_WRONG_CMD_FEAT					= "SimpleMount: the feature you specified can not be %s.";
SIMPLEMOUNT_ERROR_NO_VALUE_TO_SET					= "SimpleMount: no value given to set.";

SIMPLEMOUNT_WRONG_CMD_FEAT_LIST						= {};
SIMPLEMOUNT_WRONG_CMD_FEAT_LIST["toggle"]			= "toggled";
SIMPLEMOUNT_WRONG_CMD_FEAT_LIST["enable"]			= "enabled";
SIMPLEMOUNT_WRONG_CMD_FEAT_LIST["disable"]			= "disabled";
SIMPLEMOUNT_WRONG_CMD_FEAT_LIST["set"]				= "set";


SIMPLEMOUNT_OPTIONS_CMD_USAGE						= {
	" Usage: /simplemount <command> [parameters]";
	"",
	"Commands:",
	" toggle [feature] - toggle SimpleMount or specified feature on/off",
	" enable [feature] - enable SimpleMount or specified feature",
	" disable [feature] - disable SimpleMount (or specified feature)",
	" set <feature> <value> - sets the feature to value",
	" help - displays this information",
	"",
	"Features:",
	" main - main code, will restore behaviour of system to as close to pre-SimpleMount as is possible",
	" gathering - part that influence the dismount/mount when attemping to gather stuff",
	" mailbox - part that influence the dismount/mount when accessing the mailbox",
	" mailboxopen - whether to mount after opening the mailbox or not",
	" mailboxclose - whether to mount after closing the mailbox or not",
	-- SIMPLEMOUNT_COMBAT START
	--[[
	" aftercombat - whether to remount after you leave combat or not",
	" aftercombattimeout - how long time after combat to wait (resets to 1 second if you loot)",
	]]--
	-- SIMPLEMOUNT_COMBAT END

};

--- Khaos

SIMPLEMOUNT_KHAOS_FOLDER_TEXT						= "SimpleMount";
SIMPLEMOUNT_KHAOS_FOLDER_HELP						= "Contains settings for SimpleMount, the AddOn that makes using a mount much easier.";

SIMPLEMOUNT_KHAOS_EASYSET_TEXT					= "Basic";
SIMPLEMOUNT_KHAOS_EASYSET_HELP					= "Contains the basic options, controlling broad behaviour of the AddOn.";

SIMPLEMOUNT_KHAOS_ADVANCEDSET_TEXT				= "Advanced";
SIMPLEMOUNT_KHAOS_ADVANCEDSET_HELP				= "Contains the advanced options, allowing for fine-grained control of the AddOn.";

SIMPLEMOUNT_KHAOS_ENABLE_TEXT						= "Enable SimpleMount";
SIMPLEMOUNT_KHAOS_ENABLE_HELP						= "Determines if SimpleMount is allowed to do anything at all. If disabled, nothing will happen, though some code will still run.";

SIMPLEMOUNT_KHAOS_GATHERING_TEXT					= "Handle gathering";
SIMPLEMOUNT_KHAOS_GATHERING_HELP					= "Whether SimpleMount should handle gathering.";

SIMPLEMOUNT_KHAOS_MAILBOX_TEXT						= "Handle mailbox";
SIMPLEMOUNT_KHAOS_MAILBOX_HELP						= "Whether SimpleMount should handle interacting with the mailbox.";

SIMPLEMOUNT_KHAOS_COMBAT_TEXT						= "Remount after combat";
SIMPLEMOUNT_KHAOS_COMBAT_HELP						= "Whether SimpleMount should remount after combat is done (will wait for looting).";

SIMPLEMOUNT_KHAOS_MBREMOUNTCLOSE_TEXT				= "Handle mailbox close";
SIMPLEMOUNT_KHAOS_MBREMOUNTCLOSE_HELP				= "Whether SimpleMount should remount after closing the mailbox.";

SIMPLEMOUNT_KHAOS_MBREMOUNTOPEN_TEXT				= "Handle mailbox open";
SIMPLEMOUNT_KHAOS_MBREMOUNTOPEN_HELP				= "Whether SimpleMount should remount after the mailbox has been opened. Note that while the mailbox is usable as long as it is kept open, it can be annoying to close the mailbox and open it again often with this option enabled.";

SIMPLEMOUNT_KHAOS_GATHER_TIMEOUT_TEXT				= "Remount gather timeout";
SIMPLEMOUNT_KHAOS_GATHER_TIMEOUT_HELP				= "Determines the timespan within automatic remounting from gathering can occur. This is the time from when automatic dismounting is triggered. Setting it to zero means that time is not considered.";
SIMPLEMOUNT_KHAOS_GATHER_TIMEOUT_FORMAT				= "Gather timeout set to %d seconds.";
SIMPLEMOUNT_KHAOS_GATHER_TIMEOUT_NONE				= "No gather timeout.";

SIMPLEMOUNT_KHAOS_TIME_AFTER_LOOT_TEXT				= "Delay after looting";
SIMPLEMOUNT_KHAOS_TIME_AFTER_LOOT_HELP				= "The amount of time to wait after looting gathered stuff to trigger remounting.";
SIMPLEMOUNT_KHAOS_TIME_AFTER_LOOT_FORMAT			= "Remounting delay after looting: %2f seconds";

SIMPLEMOUNT_KHAOS_TIME_AFTER_LOOT_MULT_TEXT			= "Delay after looting iterative";
SIMPLEMOUNT_KHAOS_TIME_AFTER_LOOT_MULT_HELP			= "The amount of time to wait after looting iterative stuff (mining, getting more than one round of stuff from the same node) to remount.";
SIMPLEMOUNT_KHAOS_TIME_AFTER_LOOT_MULT_FORMAT		= "Remounting delay after looting iterative: %2f seconds";

SIMPLEMOUNT_KHAOS_COMBAT_TIMEOUT_TEXT				= "Combat remount timeout";
SIMPLEMOUNT_KHAOS_COMBAT_TIMEOUT_HELP				= "The maximum time to wait after combat ends before remounting.";
SIMPLEMOUNT_KHAOS_COMBAT_TIMEOUT_FORMAT				= SIMPLEMOUNT_KHAOS_COMBAT_TIMEOUT_TEXT..": %2f seconds";

--- Cosmos
--reuses Khaos

SIMPLEMOUNT_CONFIG_HEADER							= SIMPLEMOUNT_KHAOS_FOLDER_TEXT;
SIMPLEMOUNT_CONFIG_HEADER_INFO						= SIMPLEMOUNT_KHAOS_FOLDER_HELP;

SIMPLEMOUNT_STATE_ENABLED							= "enabled";
SIMPLEMOUNT_STATE_DISABLED							= "disabled";

SIMPLEMOUNT_CHAT_ENABLED							= "SimpleMount %s.";

SIMPLEMOUNT_CHAT_GATHERING							= "SimpleMount handle gathering %s.";
SIMPLEMOUNT_CHAT_SUMMON								= "SimpleMount summoning mounts %s (requires ActionQueue).";
SIMPLEMOUNT_CHAT_MAILBOX							= "SimpleMount handle mailbox %s.";
SIMPLEMOUNT_CHAT_COMBAT								= "SimpleMount remount after combat %s.";

-- these should be possible to just copy/paste into any localization... should actually not be here, buuut...

SIMPLEMOUNT_CMD_CHECKBOX_CHAT_STATE					= {};
SIMPLEMOUNT_CMD_CHECKBOX_CHAT_STATE["main"]			= SIMPLEMOUNT_CHAT_ENABLED;
SIMPLEMOUNT_CMD_CHECKBOX_CHAT_STATE["summon"]		= SIMPLEMOUNT_CHAT_SUMMON;
SIMPLEMOUNT_CMD_CHECKBOX_CHAT_STATE["gathering"]	= SIMPLEMOUNT_CHAT_GATHERING;
SIMPLEMOUNT_CMD_CHECKBOX_CHAT_STATE["mailbox"]		= SIMPLEMOUNT_CHAT_MAILBOX;
SIMPLEMOUNT_CMD_CHECKBOX_CHAT_STATE["combat"]		= SIMPLEMOUNT_CHAT_COMBAT;

SIMPLEMOUNT_CMD_SET_CHAT_STATE					= {};
SIMPLEMOUNT_CMD_SET_CHAT_STATE["gathering"]		= SIMPLEMOUNT_KHAOS_GATHER_TIMEOUT_FORMAT;
SIMPLEMOUNT_CMD_SET_CHAT_STATE["loottimeout"]		= SIMPLEMOUNT_KHAOS_TIME_AFTER_LOOT_FORMAT;
SIMPLEMOUNT_CMD_SET_CHAT_STATE["lootmulttimeout"]	= SIMPLEMOUNT_KHAOS_TIME_AFTER_LOOT_MULT_FORMAT;
SIMPLEMOUNT_CMD_SET_CHAT_STATE["combattimeout"]	= SIMPLEMOUNT_KHAOS_COMBAT_TIMEOUT_FORMAT;
