OneHitWonder_Mage_ShouldBuffNonCastersIntellect = 0;
OneHitWonder_Mage_ShouldReactiveCastFireWard = 1;
OneHitWonder_Mage_ShouldReactiveCastFrostWard = 1;
OneHitWonder_Mage_ShouldReactiveCastManaShield = 0;

OneHitWonder_Mage_ShouldBuffDampenMagicWhenNoHealer = 0;

OneHitWonder_Mage_ReactiveManaShieldHealthPercentage = 30;
OneHitWonder_Mage_ReactiveManaShieldManaPercentage = 70;

function OneHitWonder_Mage_SetShouldBuffNonCastersIntellect(toggle)
	OneHitWonder_Mage_ShouldBuffNonCastersIntellect = toggle;
end

function OneHitWonder_Mage_SetShouldReactiveCastFireWard(toggle)
	OneHitWonder_Mage_ShouldReactiveCastFireWard = toggle;
end

function OneHitWonder_Mage_SetShouldReactiveCastFrostWard(toggle)
	OneHitWonder_Mage_ShouldReactiveCastFrostWard = toggle;
end

function OneHitWonder_Mage_SetShouldReactiveCastManaShield(toggle)
	OneHitWonder_Mage_ShouldReactiveCastManaShield = toggle;
end

function OneHitWonder_Mage_SetReactiveManaShieldHealthPercentage(toggle, value)
	OneHitWonder_Mage_ReactiveManaShieldHealthPercentage = value;
end

function OneHitWonder_Mage_SetReactiveManaShieldManaPercentage(toggle, value)
	OneHitWonder_Mage_ReactiveManaShieldManaPercentage = value;
end

function OneHitWonder_Mage_SetShouldBuffDampenMagicWhenNoHealer(toggle)
	OneHitWonder_Mage_ShouldBuffDampenMagicWhenNoHealer = toggle;
end

function OneHitWonder_Mage_Cosmos()
	if ( Cosmos_RegisterConfiguration ) then
		Cosmos_RegisterConfiguration(
			"COS_ONEHITWONDER_MAGE_SEPARATOR",
			"SEPARATOR",
			TEXT(ONEHITWONDER_MAGE_SEPARATOR),
			TEXT(ONEHITWONDER_MAGE_SEPARATOR_INFO)
		);
		Cosmos_RegisterConfiguration(
			"COS_ONEHITWONDER_MAGE_BUFF_NON_CASTERS_INTELLECT",
			"CHECKBOX",
			TEXT(ONEHITWONDER_MAGE_BUFF_NON_CASTERS_INTELLECT),
			TEXT(ONEHITWONDER_MAGE_BUFF_NON_CASTERS_INTELLECT_INFO),
			OneHitWonder_Mage_SetShouldBuffNonCastersIntellect,
			OneHitWonder_Mage_ShouldBuffNonCastersIntellect
		);
		Cosmos_RegisterConfiguration(
			"COS_ONEHITWONDER_MAGE_BUFF_DAMPEN_MAGIC_WHEN_NO_HEALERS",
			"CHECKBOX",
			TEXT(ONEHITWONDER_MAGE_BUFF_DAMPEN_MAGIC_WHEN_NO_HEALERS),
			TEXT(ONEHITWONDER_MAGE_BUFF_DAMPEN_MAGIC_WHEN_NO_HEALERS_INFO),
			OneHitWonder_Mage_SetShouldBuffDampenMagicWhenNoHealer,
			OneHitWonder_Mage_ShouldBuffDampenMagicWhenNoHealer
		);
		
		Cosmos_RegisterConfiguration(
			"COS_ONEHITWONDER_MAGE_REACTIVE_CAST_FIRE_WARD",
			"CHECKBOX",
			TEXT(ONEHITWONDER_MAGE_REACTIVE_CAST_FIRE_WARD),
			TEXT(ONEHITWONDER_MAGE_REACTIVE_CAST_FIRE_WARD_INFO),
			OneHitWonder_Mage_SetShouldReactiveCastFireWard,
			OneHitWonder_Mage_ShouldReactiveCastFireWard
		);
		Cosmos_RegisterConfiguration(
			"COS_ONEHITWONDER_MAGE_REACTIVE_CAST_FROST_WARD",
			"CHECKBOX",
			TEXT(ONEHITWONDER_MAGE_REACTIVE_CAST_FROST_WARD),
			TEXT(ONEHITWONDER_MAGE_REACTIVE_CAST_FROST_WARD_INFO),
			OneHitWonder_Mage_SetShouldReactiveCastFrostWard,
			OneHitWonder_Mage_ShouldReactiveCastFrostWard
		);
		Cosmos_RegisterConfiguration(
			"COS_ONEHITWONDER_MAGE_REACTIVE_CAST_MANA_SHIELD",
			"CHECKBOX",
			TEXT(ONEHITWONDER_MAGE_REACTIVE_CAST_MANA_SHIELD),
			TEXT(ONEHITWONDER_MAGE_REACTIVE_CAST_MANA_SHIELD_INFO),
			OneHitWonder_Mage_SetShouldReactiveCastManaShield,
			OneHitWonder_Mage_ShouldReactiveCastManaShield
		);
		Cosmos_RegisterConfiguration(
			"COS_ONEHITWONDER_MAGE_REACTIVE_MANA_SHIELD_HEALTH",
			"SLIDER",
			TEXT(ONEHITWONDER_MAGE_REACTIVE_MANA_SHIELD_HEALTH),
			TEXT(ONEHITWONDER_MAGE_REACTIVE_MANA_SHIELD_HEALTH_INFO),
			OneHitWonder_Mage_SetReactiveManaShieldHealthPercentage,
			1,
			OneHitWonder_Mage_ReactiveManaShieldHealthPercentage,
			0,
			100,
			"",
			1,
			1,
			TEXT(ONEHITWONDER_MAGE_REACTIVE_MANA_SHIELD_HEALTH_APPEND)
		);
		Cosmos_RegisterConfiguration(
			"COS_ONEHITWONDER_MAGE_REACTIVE_MANA_SHIELD_MANA",
			"SLIDER",
			TEXT(ONEHITWONDER_MAGE_REACTIVE_MANA_SHIELD_MANA),
			TEXT(ONEHITWONDER_MAGE_REACTIVE_MANA_SHIELD_MANA_INFO),
			OneHitWonder_Mage_SetReactiveManaShieldManaPercentage,
			1,
			OneHitWonder_Mage_ReactiveManaShieldManaPercentage,
			1,
			100,
			"",
			1,
			1,
			TEXT(ONEHITWONDER_MAGE_REACTIVE_MANA_SHIELD_MANA_APPEND)
		);
	end
end


function OneHitWonder_SetupStuffContinously_Mage()
	OneHitWonder_BuffTime[ONEHITWONDER_SPELL_ARCANE_INTELLECT_NAME] = 29*60;
	OneHitWonder_BuffTime[ONEHITWONDER_SPELL_DAMPEN_MAGIC_NAME] = 4.5*60;
	if ( OneHitWonder_Mage_ShouldBuffNonCastersIntellect == 1 ) then
		OneHitWonder_AddStuffContinously(ONEHITWONDER_SPELL_ARCANE_INTELLECT_NAME, false, true);
	else
		OneHitWonder_AddStuffContinously(ONEHITWONDER_SPELL_ARCANE_INTELLECT_NAME, false, true, {powerType = OneHitWonder_ManaClassesArray});
		--OneHitWonder_AddStuffContinously(ONEHITWONDER_SPELL_ARCANE_INTELLECT_NAME, false, true, {onlyBuffClass = {ONEHITWONDER_CLASS_DRUID}, powerType = { ONEHITWONDER_POWERTYPE_MANA } });
		OneHitWonder_AddStuffContinously(ONEHITWONDER_SPELL_ARCANE_INTELLECT_NAME, false, true, {onlyBuffClass = {ONEHITWONDER_CLASS_DRUID}});
	end
	local armorName = ONEHITWONDER_SPELL_ICE_ARMOR_NAME;
	if ( OneHitWonder_GetSpellId(armorName) <= 0 ) then
		armorName = ONEHITWONDER_SPELL_FROST_ARMOR_NAME;
	end
	OneHitWonder_AddStuffContinously(armorName, true, true);
	if ( ( OneHitWonder_Mage_ShouldBuffDampenMagicWhenNoHealer == 1 ) and ( OneHitWonder_GetNumberOfClassInParty(OneHitWonder_HealerClassesArray) <= 0 ) ) then
		OneHitWonder_AddStuffContinously(ONEHITWONDER_SPELL_DAMPEN_MAGIC_NAME, false, true, {invalidTarget={"target"},validTarget={"player","party1","party2","party3","party4","pet"}});
	end
end

function OneHitWonder_TryToInterruptSpell_Mage(unitName, spellName)
	local interruptId = -1;
	local abilityName = "";
	if ( OneHitWonder_IsSpellFireBased(spellName) ) then
		abilityName = ONEHITWONDER_SPELL_FIRE_WARD_NAME;
	elseif ( OneHitWonder_IsSpellFrostBased(spellName) ) then
		abilityName = ONEHITWONDER_SPELL_FROST_WARD_NAME;
	end
	if ( ( abilityName ) and 
		(strlen(abilityName) > 0) and ( not OneHitWonder_HasPlayerEffect(nil, abilityName) ) ) then
		interruptId = OneHitWonder_GetSpellId(abilityName);
		if ( OneHitWonder_CheckIfSpellIsCoolingdownById(interruptId) ) then
			abilityName = "";
			interruptId = -1;
		end
	end
	return interruptId, abilityName;
end

function OneHitWonder_Mage_UnitHealthCheck()
	if ( OneHitWonder_Mage_ShouldReactiveCastManaShield == 1 ) then
		local playerHPPercent = OneHitWonder_GetPlayerHPPercentage();
		local playerManaPercent = OneHitWonder_GetPlayerManaPercentage();
		if ( ( playerHPPercent <= OneHitWonder_Mage_ReactiveManaShieldHealthPercentage ) 
			and ( playerManaPercent >= OneHitWonder_Mage_ReactiveManaShieldManaPercentage ) ) then
			local spellId = OneHitWonder_GetSpellId(ONEHITWONDER_SPELL_MANA_SHIELD_NAME);
			if ( 
			( spellId > -1 ) and 
			( OneHitWonder_IsSpellAvailable(spellId) ) and 
			( OneHitWonder_HasPlayerEffect(nil, ONEHITWONDER_SPELL_MANA_SHIELD_EFFECT ) ) ) then
				OneHitWonder_AddActionToQueue(ONEHITWONDER_ACTIONID_SPELL_TIMEOUT, { spellId, ( GetTime() + 2) }  );
			end
		end
	end
end


function OneHitWonder_Mage(removeDefense)
	local targetName = UnitName("target");

	if ( not removeDefense ) then removeDefense = false; end
	
	if ( OneHitWonder_ChannelSpellRunning ) then
		return;
	end
	
	if ( (not targetName) or ( strlen(targetName) <= 0 ) ) then
		if ( not OneHitWonder_UseCountermeasures() ) then
			OneHitWonder_DoBuffs();
		end
		return;
	end
	
	if ( not UnitCanAttack("target", "player") ) then
		if ( not OneHitWonder_UseCountermeasures() ) then
			OneHitWonder_DoBuffs();
		end
		return;
	end
	
	OneHitWonder_CheckFriendlies();
	
	if ( OneHitWonder_HandleActionQueue() ) then
		return;
	end

	-- check fire ball range, use that, default to frost bolt if necessary, AM

	if ( not OneHitWonder_DoBuffs() ) then
		local attackSpellId = OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_ATTACK);
		local attackActionId = OneHitWonder_GetActionIdFromSpellId(attackSpellId);
		if ( attackActionId == -1 ) or ( not OneHitWonder_CheckIfInRangeAndUsableInActionBarByActionId(attackActionId) ) then
			local shootSpellId = OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_SHOOT);
			local shootActionId = OneHitWonder_GetActionIdFromSpellId(shootSpellId);
			if ( OneHitWonder_CheckIfInRangeAndUsableInActionBarByActionId(shootActionId) ) then
				if ( OneHitWonder_CastSpell(shootSpellId) ) then	
					return;
				end
			end
		else
			if ( PlayerFrame.inCombat ~= 1 ) then
				AttackTarget();
			end
		end
	end
end

function OneHitWonder_Mage_IsEffectLesserCurse(effect)
	if ( strfind(effect.name, ONEHITWONDER_DEBUFF_TYPE_CURSE_LESSER ) ) then
		return true;
	end
	for k, v in ONEHITWONDER_LESSER_CURSE_NAMES do
		if ( v == effect.name ) then
			return true;
		end
	end
	return false;
end

function OneHitWonder_CheckEffect_Mage(unit)
	if ( ( strfind(unit, "party" ) ) or ( unit == "player" ) ) then
		if ( OneHitWonder_ShouldRemoveDebuffs == 1 ) then
			local removeCurseId = OneHitWonder_GetSpellId(ONEHITWONDER_SPELL_REMOVE_LESSER_CURSE_NAME);
			if ( removeCurseId > -1 ) then
				local debuffsByType = OneHitWonder_GetDebuffsByType(unit);
				local hasCurse = ( debuffsByType[ONEHITWONDER_DEBUFF_TYPE_CURSE] ) and ( table.getn(debuffsByType[ONEHITWONDER_DEBUFF_TYPE_CURSE]) > 0 );
				local hasLesserCurse = false;
				if ( hasCurse ) then
					for k, v in debuffsByType[ONEHITWONDER_DEBUFF_TYPE_CURSE] do
						if ( OneHitWonder_Mage_IsEffectLesserCurse(v) ) then
							hasLesserCurse = true;
							break;
						end
					end
				end
				if ( hasLesserCurse ) then
					local parameters = { removeCurseId, unit };
					OneHitWonder_AddActionToQueue(ONEHITWONDER_ACTIONID_SPELL_TARGET, parameters);
					return true;
				end
			end
		end
	end
	return false;
end
