
OneHitWonder_Priest_AutoBuffInnerFire = 1;
OneHitWonder_Priest_AutoBuffInnerFireInGroups = 1;

function OneHitWonder_ShouldAutoBuffInnerFire()
	if ( ( OneHitWonder_Priest_AutoBuffInnerFire == 0 ) or (
		( OneHitWonder_IsInPartyOrRaid() ) and ( OneHitWonder_Priest_AutoBuffInnerFireInGroups == 0 ) )  
		) then
		return false;
	else
		return true;
	end
end

function OneHitWonder_SetAutoBuffInnerFire(toggle)
	if ( OneHitWonder_Priest_AutoBuffInnerFire ~= toggle ) then
		OneHitWonder_Priest_AutoBuffInnerFire = toggle;
		OneHitWonder_SetupStuffContinously();
	end
end

function OneHitWonder_SetAutoBuffInnerFireInGroups(toggle)
	if ( OneHitWonder_Priest_AutoBuffInnerFireInGroups ~= toggle ) then
		OneHitWonder_Priest_AutoBuffInnerFireInGroups = toggle;
		if ( OneHitWonder_IsInPartyOrRaid() ) then
			OneHitWonder_SetupStuffContinously();
		end
	end
end

function OneHitWonder_SetupStuffContinously_Priest()
	OneHitWonder_BuffTime[ONEHITWONDER_ABILITY_POWER_WORD_FORTITUDE_NAME] = 25*60;
	--OneHitWonder_BuffTime[ONEHITWONDER_ABILITY_INNER_FIRE_NAME] = 5*60;
	OneHitWonder_AddStuffContinously(ONEHITWONDER_ABILITY_POWER_WORD_FORTITUDE_NAME, false, true);
	if ( OneHitWonder_ShouldAutoBuffInnerFire() ) then
		OneHitWonder_AddStuffContinously(ONEHITWONDER_ABILITY_INNER_FIRE_NAME, true, true);
	end
end

function OneHitWonder_Priest_Cosmos()
	if ( Cosmos_RegisterConfiguration ) then
		Cosmos_RegisterConfiguration(
			"COS_ONEHITWONDER_PRIEST_SEPARATOR",
			"SEPARATOR",
			TEXT(ONEHITWONDER_PRIEST_SEPARATOR),
			TEXT(ONEHITWONDER_PRIEST_SEPARATOR_INFO)
		);
		Cosmos_RegisterConfiguration(
			"COS_ONEHITWONDER_PRIEST_BUFF_INNER_FIRE",
			"CHECKBOX",
			TEXT(ONEHITWONDER_PRIEST_BUFF_INNER_FIRE),
			TEXT(ONEHITWONDER_PRIEST_BUFF_INNER_FIRE_INFO),
			OneHitWonder_SetAutoBuffInnerFire,
			OneHitWonder_Priest_AutoBuffInnerFire
		);
		Cosmos_RegisterConfiguration(
			"COS_ONEHITWONDER_PRIEST_BUFF_INNER_FIRE_IN_GROUPS",
			"CHECKBOX",
			TEXT(ONEHITWONDER_PRIEST_BUFF_INNER_FIRE_IN_GROUPS),
			TEXT(ONEHITWONDER_PRIEST_BUFF_INNER_FIRE_IN_GROUPS_INFO),
			OneHitWonder_SetAutoBuffInnerFireInGroups,
			OneHitWonder_Priest_AutoBuffInnerFireInGroups
		);
	end
end

function OneHitWonder_Priest(removeDefense)
	local targetName = UnitName("target");

	if ( not removeDefense ) then removeDefense = false; end
	
	if ( OneHitWonder_ChannelSpellRunning ) then
		return;
	end
	
	if ( (not targetName) or ( strlen(targetName) <= 0 ) ) then
		if ( not OneHitWonder_UseCountermeasures() ) then
			OneHitWonder_DoBuffs();
		end
		return;
	end
	
	if ( not UnitCanAttack("player", "target") ) then
		if ( not OneHitWonder_UseCountermeasures() ) then
			OneHitWonder_DoBuffs();
		end
		return;
	end
	
	OneHitWonder_CheckFriendlies();
	
	if ( OneHitWonder_HandleActionQueue() ) then
		return;
	end

	if ( PlayerFrame.inCombat ~= 1 ) then
		AttackTarget();
	end

	if ( not OneHitWonder_DoBuffs() ) then
		if ( OneHitWonder_CastIfTargetNotHasEffect(ONEHITWONDER_ABILITY_SHOOT, ONEHITWONDER_ABILITY_SHOOT) ) then
			return;
		end
	end
end

function OneHitWonder_CheckEffect_Priest(unit)
	if ( ( strfind(unit, "party" ) ) or ( unit == "player" ) ) then
		if ( OneHitWonder_ShouldRemoveDebuffs == 1 ) then
			local abolishDiseaseId = OneHitWonder_GetSpellId(ONEHITWONDER_SPELL_ABOLISH_DISEASE_NAME);
			local cureDiseaseId = OneHitWonder_GetSpellId(ONEHITWONDER_SPELL_CURE_DISEASE_NAME);
			if ( abolishDiseaseId > -1 ) or ( cureDiseaseId > -1 ) then
				local debuffsByType = OneHitWonder_GetDebuffsByType(unit);
				local hasDisease = ( debuffsByType[ONEHITWONDER_DEBUFF_TYPE_DISEASE] ) and ( table.getn(debuffsByType[ONEHITWONDER_DEBUFF_TYPE_DISEASE]) > 0 );
				if ( hasDisease ) then
					local spellId = -1;
					if ( table.getn(debuffsByType[ONEHITWONDER_DEBUFF_TYPE_DISEASE]) > 1 ) then
						spellId = abolishDiseaseId;
					end
					if ( spellId <= -1 ) then
						spellId = cureDiseaseId;
					end
					if ( ( spellId > -1 ) and ( OneHitWonder_IsUnitInRange(unit) ) ) then
						local parameters = { spellId, unit };
						OneHitWonder_AddActionToQueue(ONEHITWONDER_ACTIONID_SPELL_TARGET, parameters);
						return true;
					end
				end
			end
		end
	end
	return false;
end
