--[[

Currently compatible with:
Sky
Guilded

To make your addon compatible, you can simply inject this piece of code before sending a message you want to keep from being spell corrected:
if ( SpellChecker2_Setup ) then
	SpellChecker2_Setup.ignoreNextMessage = true;
end

To spell correct a message:
msg = SpellChecker2_CorrectMessage(msg);
Note: if you want to keep the first letter from being capitalized, you need to use:
msg = SpellChecker2_CorrectMessage(msg, true);


]]--

function SpellChecker2_CompatibilityCheck()
	if ( IsAddOnLoaded("Earth") ) and ( not SpellChecker2_EarthLoaded ) then
		-- Check for addons? Is this possible?
		if ( EarthFeature_AddButton ) and ( SpellChecker2_GUI_ToggleShow ) then
			EarthFeature_AddButton (
				{ 
					id = "SPELLCHECKER2_GUI";
					name = SPELLCHECKER2_EARTH_BUTTON_NAME;
					subtext = SPELLCHECKER2_EARTH_BUTTON_SUBTEXT;
					tooltip = SPELLCHECKER2_EARTH_BUTTON_TOOLTIP;
					icon = SPELLCHECKER2_EARTH_BUTTON_ICON;
					callback = SpellChecker2_SlashCommand_GUI;
					test = 	function()
						return true;
					end
				});
			SpellChecker2_EarthLoaded = true;
		end
	end
	if ( IsAddOnLoaded("Sky") ) and ( SkyChannelManager ) then
		if ( SkyChannelManager.sendMessageToChannel ) and ( not SpellChecker2_SkyChannelManager_Saved_sendMessageToChannel ) then
			SpellChecker2_SkyChannelManager_Saved_sendMessageToChannel = SkyChannelManager.sendMessageToChannel;
			SkyChannelManager.sendMessageToChannel = SpellChecker2_SkyChannelManager_sendMessageToChannel;
		end
		if ( SkyChannelManager.sendWhisper ) and ( not SpellChecker2_SkyChannelManager_Saved_sendWhisper ) then
			SpellChecker2_SkyChannelManager_Saved_sendWhisper = SkyChannelManager.sendWhisper;
			SkyChannelManager.sendWhisper = SpellChecker2_SkyChannelManager_sendWhisper;
		end
		if ( SkyChannelManager.sendSpecial ) and ( not SpellChecker2_SkyChannelManager_Saved_sendSpecial ) then
			SpellChecker2_SkyChannelManager_Saved_sendSpecial = SkyChannelManager.sendSpecial;
			SkyChannelManager.sendSpecial = SpellChecker2_SkyChannelManager_sendSpecial;
		end
	end
	if ( IsAddOnLoaded("Guilded") ) and ( ChanComm ) then
		if ( ChanComm.SendChatMessage_Override ) and ( not SpellChecker2_ChanComm_Saved_SendChatMessage_Override ) then
			SpellChecker2_ChanComm_Saved_SendChatMessage_Override = ChanComm.SendChatMessage_Override;
			ChanComm.SendChatMessage_Override = SpellChecker2_ChanComm_SendChatMessage_Override;
		end
		
	end
end

-- Guilded/ChanComm compatibility

function SpellChecker2_ChanComm_SendChatMessage_Override(msg, sys, lang, name, p1, p2, p3, p4, p5)
	SpellChecker2_Setup.ignoreNextMessage = true;
	return SpellChecker2_ChanComm_Saved_SendChatMessage_Override(msg, sys, lang, name, p1, p2, p3, p4, p5)
end

-- Sky compatibility

function SpellChecker2_SkyChannelManager_sendMessageToChannel(message, channelNameOrNumber, ignoreBandwidth, p1, p2, p3, p4, p5)
	if ( channelNameOrNumber ) and ( channelNameOrNumber == SKY_CHANNEL ) then
		SpellChecker2_Setup.ignoreNextMessage = true;
	end
	return SpellChecker2_SkyChannelManager_Saved_sendMessageToChannel(message, channelNameOrNumber, ignoreBandwidth, p1, p2, p3, p4, p5);
end

function SpellChecker2_SkyChannelManager_sendWhisper(message, player, ignoreBandwidth, p1, p2, p3, p4, p5)
	SpellChecker2_Setup.ignoreNextMessage = true;
	return SpellChecker2_SkyChannelManager_Saved_sendWhisper(message, player, ignoreBandwidth, p1, p2, p3, p4, p5);
end

function SpellChecker2_SkyChannelManager_sendSpecial(message, spec, ignoreBandwidth, p1, p2, p3, p4, p5)
	SpellChecker2_Setup.ignoreNextMessage = true;
	return SpellChecker2_SkyChannelManager_Saved_sendSpecial(message, spec, ignoreBandwidth, p1, p2, p3, p4, p5);
end

