SpellChecker2_Options_Khaos_Registered = nil;

function SpellChecker2_Options_VariablesLoaded()
	SpellChecker2_Options_Register_Khaos();
end

function SpellChecker2_GetFeedback_Boolean(state, msg)
	local stateMsg = SPELLCHECKER2_STATE_BOOLEAN_TRUE;
	if ( not state ) then
		stateMsg = SPELLCHECKER2_STATE_BOOLEAN_FALSE;
	end
	return format(msg, stateMsg);
end

function SpellChecker2_SetEnabled(state)
	if ( state == nil ) then state = false; end
	SpellChecker2_Options.enabled = state;
end

function SpellChecker2_SetCorrectIncomingMessages(state)
	if ( state == nil ) then state = false; end
	SpellChecker2_Options.correctIncomingMessages = state;
end

function SpellChecker2_SetCorrectOutgoingMessages(state)
	if ( state == nil ) then state = false; end
	SpellChecker2_Options.correctOutgoingMessages = state;
end

function SpellChecker2_SetStartCapitalization(state)
	if ( state == nil ) then state = false; end
	SpellChecker2_Options.startCapitalization = state;
end

function SpellChecker2_SetOnTheFlyCorrection(state)
	if ( state == nil ) then state = false; end
	SpellChecker2_Options.onTheFlyCorrection = state;
end

function SpellChecker2_Options_Register_Khaos()
	if ( SpellChecker2_Options_Khaos_Registered ) then
		return true;
	end
	if ( Khaos ) and ( Khaos.registerOptionSet ) then
		SpellChecker2_Options_Khaos_Registered = true;

		local optionSetEasy = {
			id = SPELLCHECKER2_KHAOS_SET_ID;
			text = SPELLCHECKER2_CONFIG_HEADER;
			helptext = SPELLCHECKER2_CONFIG_HEADER_INFO;
			callback = function(state) SpellChecker2_SetEnabled(state); end;
			difficulty = 1;
			default = true;
			options = {
				{
					id = "SpellChecker2Header";
					key = "header";
					text = SPELLCHECKER2_CONFIG_HEADER;
					helptext = SPELLCHECKER2_CONFIG_HEADER_INFO;
					type = K_HEADER;
					callback = function () end;
				},
				{
					id = "SpellChecker2CheckBoxEnabled";
					key = "enabled";
					text = SPELLCHECKER2_CONFIG_ENABLED;
					helptext = SPELLCHECKER2_CONFIG_ENABLED_INFO;
					check = true;
					callback = function(state) SpellChecker2_SetEnabled(state.checked); end;
					type = K_TEXT;
					feedback = function(state) return SpellChecker2_GetFeedback_Boolean(state.checked, SPELLCHECKER2_MSG_STATE_ENABLED); end;
					default = {
						checked = SPELLCHECKER2_OPTIONS_DEFAULT.enabled;
					};
					disabled = {
						checked = false;
					};
				},
				{
					id = "SpellChecker2CheckBoxCorrectIncomingMessages";
					key = "correctIncomingMessages";
					text = SPELLCHECKER2_CONFIG_INCOMING_MSGS;
					helptext = SPELLCHECKER2_CONFIG_INCOMING_MSGS_INFO;
					check = true;
					callback = function(state) SpellChecker2_SetCorrectIncomingMessages(state.checked); end;
					type = K_TEXT;
					feedback = function(state) return SpellChecker2_GetFeedback_Boolean(state.checked, SPELLCHECKER2_MSG_STATE_INCOMING_MSGS); end;
					default = {
						checked = SPELLCHECKER2_OPTIONS_DEFAULT.correctIncomingMessages;
					};
					disabled = {
						checked = false;
					};
				},
				{
					id = "SpellChecker2CheckBoxCorrectOutgoingMessages";
					key = "correctOutgoingMessages";
					text = SPELLCHECKER2_CONFIG_OUTGOING_MSGS;
					helptext = SPELLCHECKER2_CONFIG_OUTGOING_MSGS_INFO;
					check = true;
					callback = function(state) SpellChecker2_SetCorrectOutgoingMessages(state.checked); end;
					type = K_TEXT;
					feedback = function(state) return SpellChecker2_GetFeedback_Boolean(state.checked, SPELLCHECKER2_MSG_STATE_OUTGOING_MSGS); end;
					default = {
						checked = SPELLCHECKER2_OPTIONS_DEFAULT.correctOutgoingMessages;
					};
					disabled = {
						checked = false;
					};
				},
				{
					id = "SpellChecker2CheckBoxStartCapitalization";
					key = "startCapitalization";
					text = SPELLCHECKER2_CONFIG_START_CAP;
					helptext = SPELLCHECKER2_CONFIG_START_CAP_INFO;
					check = true;
					callback = function(state) SpellChecker2_SetStartCapitalization(state.checked); end;
					type = K_TEXT;
					feedback = function(state) return SpellChecker2_GetFeedback_Boolean(state.checked, SPELLCHECKER2_MSG_STATE_START_CAP); end;
					default = {
						checked = SPELLCHECKER2_OPTIONS_DEFAULT.startCapitalization;
					};
					disabled = {
						checked = false;
					};
				},
				{
					id = "SpellChecker2CheckBoxOnTheFlyCorrection";
					key = "onTheFlyCorrection";
					text = SPELLCHECKER2_CONFIG_ON_THE_FLY;
					helptext = SPELLCHECKER2_CONFIG_ON_THE_FLY_INFO;
					check = true;
					callback = function(state) SpellChecker2_SetOnTheFlyCorrection(state.checked); end;
					type = K_TEXT;
					feedback = function(state) return SpellChecker2_GetFeedback_Boolean(state.checked, SPELLCHECKER2_MSG_STATE_ON_THE_FLY); end;
					default = {
						checked = SPELLCHECKER2_OPTIONS_DEFAULT.onTheFlyCorrection;
					};
					disabled = {
						checked = false;
					};
				}
			};
		};
		Khaos.registerOptionSet( "chat", optionSetEasy );
	else
		return false;
	end
end
