--[[
   CQuote v1.0
      Par Nyu <nyuuuu@gmail.com>

   Mod d'enregistrement de citations  la con
   pour le canal de guilde.

   Usage:
     /cquote on  -> Active le mod (activ par dfaut)
     /cquote off -> Dsactive le mod

   Commande sur le canal guilde:
     !quote      -> Cite une quote alatoire
     !quote X    -> Cite la quote numro X
     !addquote X -> Ajoute la citation X
     !lastquote  -> Cite la dernire quote
     !delquote X -> Efface la citation X
                   (Ne fonctionne que pour le
                    possesseur du mod)

  ---------------------------------------------------
   CQuote v1.0
      By Nyu <nyuuuu@gmail.com>

   Mod used for recording nice words used by guildmate
   on the guild channel.

   Usage:
     /cquote on  -> Turn the mod ON (by default)
     /cquote off -> Turn the mod OFF

   Commands on the Guild channel:
     !quote      -> Display a random quote
     !quote X    -> Display the quote number X
     !addquote X -> Add any quote
     !lastquote  -> Display the last quote
     !delquote X -> Delete the quote X
                   (Work only for the mod's owner)
]]

-- Configuration
local CQuote_OnOff = true;

function CQuote_OnLoad()
   this:RegisterEvent("CHAT_MSG_GUILD");
   this:RegisterEvent("VARIABLES_LOADED");

   SLASH_CQuote1 = "/cquote";
   SlashCmdList["CQuote"] = function( msg )
      CQuote_ChatCommandHandler( msg );
   end

   DEFAULT_CHAT_FRAME:AddMessage("[CQuote] " .. STR_LOADED,1,1,255);
end

function CQuote_OnEvent(event)
   if (not CQuote_OnOff) then return end

   if(event == "CHAT_MSG_GUILD") then
      if(string.lower(arg1) == "!quote") then
         -- Affichage d'une quote random
         if((CQuoteNumber > 0)) then
            local nRandom = 0;
            while true do
              nRandom = random(1, CQuoteNumber);
              if (CQuoteList["Q" .. nRandom]) then break end
            end
            SendChatMessage("[CQuote] #" .. nRandom .. ": " .. CQuoteList["Q" .. nRandom], "guild");
         end
      elseif(strsub(string.lower(arg1), 0, 7) == "!quote ") then
         -- Affichage d'une quote numrote
         local nQuoteNum = strsub(arg1, 8);
         if(CQuoteList["Q" .. nQuoteNum]) then
            SendChatMessage("[CQuote] #" .. nQuoteNum .. ": " .. CQuoteList["Q" .. nQuoteNum], "guild");
         else
            SendChatMessage("[CQuote] " .. STR_UNKNOWN, "guild");
         end
      elseif(strsub(string.lower(arg1), 0, 10) == "!addquote ") then
         -- Ajout d'une quote
         local sQuote = strsub(arg1, 11);
         if(strlen(sQuote) > 1) then
            CQuoteNumber = CQuoteNumber + 1;
            CQuoteLast = CQuoteNumber;
            CQuoteList["Q" .. (CQuoteNumber)] = sQuote;
            SendChatMessage("[CQuote] " .. STR_ADDED .. CQuoteNumber .. ".", "guild");
         end
      elseif(strsub(string.lower(arg1), 0, 10) == "!delquote ") then
         -- Suppression d'une quote
         if(arg2 == UnitName("player")) then
            local nQuoteNum = strsub(arg1, 11);
            if(CQuoteList["Q" .. nQuoteNum]) then
               CQuoteList["Q" .. nQuoteNum] = nil;
               SendChatMessage("[CQuote] " .. STR_DELETED, "guild");
               if((nQuoteNum + 0) == (CQuoteLast + 0)) then
                  while true do
                     CQuoteLast = CQuoteLast - 1;
                     CQuoteNumber = CQuoteLast;
                     if(CQuoteList["Q" .. CQuoteLast]) then break end
                     if(CQuoteLast <= 1) then
                        CQuoteLast = nil;
                        break
                     end
                  end
               end
            end
         else
            SendChatMessage("[CQuote] " .. STR_DENIED, "guild");
         end
      elseif(strsub(string.lower(arg1), 0, 10) == "!lastquote") then
         -- Affichage de la dernire quote
         if((CQuoteLast) and (CQuoteList["Q" .. CQuoteLast])) then
            SendChatMessage("[CQuote] #" .. CQuoteLast .. ": " .. CQuoteList["Q" .. CQuoteLast], "guild");
         end
      end
   elseif(event == "VARIABLES_LOADED") then
      if( not CQuoteList ) then
         CQuoteList = { };
         CQuoteNumber = 0;
         CQuoteLast = nil;
      end
   end
end

function CQuote_ChatCommandHandler(msg)
   if ( string.lower(msg) == "on") then
      CQuote_OnOff = true;
      DEFAULT_CHAT_FRAME:AddMessage("[CQuote] " .. STR_LOADED, 1, 1, 255);
      return;
   elseif ( string.lower(msg) == "off" ) then
      CQuote_OnOff = false;
      DEFAULT_CHAT_FRAME:AddMessage("[CQuote] " .. STR_UNLOADED, 1, 1, 255);
      return;
   else
      DEFAULT_CHAT_FRAME:AddMessage("[CQuote] " .. STR_AUTHOR, 1, 1, 255);
      DEFAULT_CHAT_FRAME:AddMessage("[CQuote] " .. STR_HELP, 1, 1, 255);
      return;
   end
end