tinsert(CT_RABoss_ModsToLoad, "CT_RABoss_BaronGeddon_Inferno_OnLoad");
tinsert(CT_RABoss_ModsToLoad, "CT_RABoss_Firelord_OnLoad");

function CT_RABoss_BaronGeddon_Inferno_OnLoad()
	CT_RABoss_AddEvent("Baron Geddon", "CHAT_MSG_SPELL_PERIODIC_CREATURE_BUFFS", CT_RABoss_BaronGeddon_EventHandler_Inferno);
	CT_RABoss_AddDropDownButton("Baron Geddon", { CT_RABOSS_BARON_OPT_INFERNO, CT_RABOSS_BARON_OPT_INFERNO_INFO }, "CT_RABoss_ModInfo", "alertInferno", "CT_RABoss_SetInfo");
	CT_RABoss_SetVar("Baron Geddon", "alertInferno", 1);
end

function CT_RABoss_BaronGeddon_EventHandler_Inferno(event)
	if ( not CT_RABoss_Mods["Baron Geddon"] or not CT_RABoss_Mods["Baron Geddon"]["status"] or not CT_RABoss_Mods["Baron Geddon"].enabled or not CT_RABoss_Mods["Baron Geddon"]["alertInferno"] ) then
		return;
	end
	if ( event == "CHAT_MSG_SPELL_PERIODIC_CREATURE_BUFFS" ) 
		and ( string.find(arg1, CT_RABOSS_BARON_INFERNO) ) 
		and ( not CT_RABoss_Mods["Baron Geddon"]["Inferno"] ) then
		
		CT_RABoss_Mods["Baron Geddon"]["Inferno"] = true;
		CT_RABoss_Announce(CT_RABOSS_BARON_25SECSINFERNO, false);
		CT_RABoss_PlaySound(2);
		CT_RABoss_Schedule("CT_RABoss_BaronGeddon_EventHandler_Inferno", 25, "preInfernoWarning");
		
	elseif ( event == "preInfernoWarning" ) then
	
		CT_RABoss_Mods["Baron Geddon"]["Inferno"] = false;
		CT_RABoss_Announce(CT_RABOSS_BARON_5SECSINFERNO, false);
		CT_RABoss_PlaySound(3);
	end
end



function CT_RABoss_Firelord_OnLoad()
	CT_RABoss_AddMod("Firelord", CT_RABOSS_FIRELORD_INFO, nil, CT_RABOSS_LOCATIONS_MOLTENCORE);
	
	CT_RABoss_AddEvent("Firelord", "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_BUFF", CT_RABoss_Firelord_EventHandler);
	CT_RABoss_AddEvent("Firelord", "CHAT_MSG_SPELL_PERIODIC_CREATURE_BUFFS", CT_RABoss_Firelord_EventHandler);
	
	CT_RABoss_AddDropDownButton("Firelord", { CT_RABOSS_FIRELORD_ANNOUNCE_LAVASPAWN, CT_RABOSS_FIRELORD_ANNOUNCE_LAVASPAWN_INFO }, "CT_RABoss_ModInfo", "announceLavaSpawn", "CT_RABoss_SetInfo");
	CT_RABoss_AddDropDownButton("Firelord", { CT_RABOSS_FIRELORD_TARGET_LAVASPAWN, CT_RABOSS_FIRELORD_TARGET_LAVASPAWN_INFO }, "CT_RABoss_ModInfo", "targetLavaSpawn", "CT_RABoss_SetInfo");
end

function CT_RABoss_Firelord_EventHandler(event)
	if ( not CT_RABoss_Mods["Firelord"] or not CT_RABoss_Mods["Firelord"]["status"] or not CT_RABoss_Mods["Firelord"].enabled ) then
		return;
	end
	if ( strfind(arg1, CT_RABOSS_FIRELORD_NAME_LAVASPAWN) ) then
		if ( CT_RABoss_Mods["Baron Geddon"]["announceLavaSpawn"] ) then
			CT_RABoss_Announce(CT_RABOSS_FIRELORD_MSG_SPAWN, false);
			CT_RABoss_PlaySound(3);
		end
		if ( CT_RABoss_Mods["Baron Geddon"]["targetLavaSpawn"] ) then
			TargetByName(CT_RABOSS_FIRELORD_NAME_LAVASPAWN);
		end
	end
end
