InvList_DefaultListTypes = {
	["optimal"] = 1;
	["medium"] = 1;
};

InvList_AllListTypes = {
	["optimal"] = 1;
	["medium"] = 1;
	["easy"] = 1;
	["trivial"] = 1;
};

InvList_ListTypes = {
	["optimal"] = 1;
	["medium"] = 1;
};

function InvList_SetListTypes(list)
	if ( type(list) == "table" ) then
		for k, v in pairs(InvList_ListTypes) do
			InvList_ListTypes[k] = false;
		end
		for k, v in pairs(list) do
			InvList_ListTypes[k] = v;
		end
	end
end


function InvList_OnLoad()
	InvList_SetListTypes(InvList_DefaultListTypes);

	SlashCmdList["INVLIST"] = InvList_SlashCommandHandler;
	SLASH_INVLIST1 = "/invlist";
	
	InvList_Usage();
end

InvList_Usage_String = {
	"InvList usage: /invlist [item/trade/craft/defaulttype/alltype]",
	" item gets item list (default)",
	" trade get tradeskills",
	" craft gets crafts (only Enchanting afaik)",
	" defaulttype sets default tradeskill/craft types to orange/yellow",
	" alltype sets default tradeskill/craft types to all"
};

function InvList_Usage()
	for k,v in pairs(InvList_Usage_String) do
		ChatFrame1:AddMessage(v, 1, 1, 0);
	end
end

InvList_Refresh = InvList_Refresh_Items;

function InvList_SlashCommandHandler(msg)
	if( InvListFrame:IsVisible() ) then
		HideUIPanel(InvListFrame);
	else
		InvList_Clear();
		local ok = false;
		local func = InvList_Refresh_Items();
		if ( not msg ) or ( msg == "" ) or ( string.find(msg, "item") ) or ( string.find(msg, "inv") ) then
			func = InvList_Refresh_Items();
		elseif ( string.find(msg, "trade") ) or ( string.find(msg, "skill") ) then
			func = InvList_Refresh_TradeSkill();
		elseif ( string.find(msg, "craft") ) then
			func = InvList_Refresh_Craft();
		elseif ( string.find(msg, "alltype") ) then
			InvList_SetListTypes(InvList_AllListTypes);
			ChatFrame1:AddMessage("InvList: Now showing all types of crafting/trade items");
			return;
		elseif ( string.find(msg, "defaulttype") ) then
			InvList_SetListTypes(InvList_DefaultListTypes);
			ChatFrame1:AddMessage("InvList: Now showing default types of crafting/trade items (orange/yellow)");
			return;
		elseif ( string.find(msg, "usage") ) or ( string.find(msg, "info") ) then
			InvList_Usage();
			return;
		end
		InvList_Refresh = func;
		if ( func() ) then
			INVLIST_TEXT = INVLIST_TEXT.."\r\n\r\nUpdated: [b]"..date("%Y-%m-%d %H:%M").."[/b]";
			InvListEditBox:SetText(INVLIST_TEXT);
			
			ShowUIPanel(InvListFrame);
		end
	end
end

function InvList_OnShow()
end

function EmptyBagStringComp(i, j)
	if (i ~= nil and j ~= nil) then
		local result = string.find(i,j);
		return result;
	else
		 return false;
	end
end

entryTable = {};

function sortEntryTable(a,b)
	return a.name < b.name;

end

function addItem(itemId, itemName, itemAmount)
	local index = nil;
	for k, v in pairs(entryTable) do
		if ( type(v) == "table" ) then
			if ( v.id == itemId ) then
				index = k;
				break;
			end
		end 
	end

	if ( not index ) then
		table.insert(entryTable, { id = itemId; name = itemName; amount = itemAmount });
	else
		entryTable[index].amount = entryTable[index].amount + itemAmount;
	end
end

function InvList_Refresh_Items()

	local slots;
	local bag;
	local j;
	local Text = "";
	local tab = ";";
	local itemID;
	local itemName, itemRarity;
	local quantity;
	local  maxContainerItems;
	-- itemRecord[name]=amount...
	local itemRecord = {};
	local itemList = {};
	Text = Text .. "[size=18]" .. UnitName("player") .. ":[/size]\r\n\r\n";
	-- loop through the 4 bagslots
	for bag = 0, 4 do
	    slots = GetContainerNumSlots(bag);        
	    if (not (EmptyBagStringComp(GetBagName(bag), "Quiver") or EmptyBagStringComp(GetBagName(bag), "Ammo") or EmptyBagStringComp(GetBagName(bag), "Shot"))) then
		for j=1, slots do
		    linktext = GetContainerItemLink(bag, j);
		    if not (linktext == nil) then
		    itemID = string.gsub(linktext, ".*item:(%d+):.*","%1",1);
		    itemName, _, itemRarity = GetItemInfo(itemID);
		    _, quantity = GetContainerItemInfo(bag, j);
			addItem( itemID, itemName, quantity );
		    --Text = Text .. itemID..tab..itemRarity..tab..itemName..tab..quantity.."\r\n";
		    --DEFAULT_CHAT_FRAME:AddMessage(Text);
		   end
		end
	    end
	end
	
	-- loop through bank itself
	maxContainerItems = GetContainerNumSlots(BANK_CONTAINER);
	--DEFAULT_CHAT_FRAME:AddMessage(maxContainerItems.."\n");
	if ( maxContainerItems ) then
	bag = 0;
	    for j = 1, maxContainerItems do
		linktext = GetContainerItemLink(BANK_CONTAINER, j);
		if not (linktext == nil) then
		    itemID = string.gsub(linktext, ".*item:(%d+):.*","%1",1);
		    itemName, _, itemRarity = GetItemInfo(itemID);
		    _, quantity = GetContainerItemInfo(BANK_CONTAINER, j);
			addItem( itemID, itemName, quantity );
		    --DEFAULT_CHAT_FRAME:AddMessage(Text);
		end

	    end
	else
		ChatFrame1:AddMessage("InvList: Note that the bank slots does not seem to be available.", 1, 1, 0);
	end

	-- loop through bankbags
	for bag = 5, 10 do
	    maxContainerItems = GetContainerNumSlots(bag);
	    --DEFAULT_CHAT_FRAME:AddMessage(maxContainerItems.."\n");
	    if ( maxContainerItems ) then
		for j = 1, maxContainerItems do
		linktext = GetContainerItemLink(bag, j);
		if not (linktext == nil) then
		    itemID = string.gsub(linktext, ".*item:(%d+):.*","%1",1);
		    itemName, _, itemRarity = GetItemInfo(itemID);
		    _, quantity = GetContainerItemInfo(bag, j);
			addItem( itemID, itemName, quantity );
		    --DEFAULT_CHAT_FRAME:AddMessage(Text);
		end

		end
	    end
	end

	table.sort(entryTable, sortEntryTable);
	
	local itemFormat = "[b]%d[/b] [url=http://wow.allakhazam.com/db/item.html?witem=%d]%s[/url]\r\n";
	
	for k,v in pairs(entryTable) do
		Text = Text .. format(itemFormat, v.amount, v.id, v.name);
	end
	
	InvListEditBox:SetText(Text);
	INVLIST_TEXT = Text;
	--RegisterForSave("INVLIST_TEXT");
	return true;
end

function InvList_Clear()
	InvListEditBox:SetText("");
	INVLIST_TEXT = "";
end

function InvList_Refresh_TradeSkill()
	local str = format("[b][u][size=18]%s[/size][/u][/b]\r\n\r\n", UnitName("player").." - "..GetTradeSkillLine());
	local urlFormat = "[url=http://wow.allakhazam.com/db/item.html?witem=%d]%s[/url]\r\n";
	local link,code;
	
	local skills = GetNumTradeSkills();
	if ( skills == 0 ) then
		ChatFrame1:AddMessage("InvList: Can not find tradeskill info. Open tradeskill window and try again.", 1,1,0);
		HideUIPanel(InvListFrame);
		return false;
	end
	
	for i=1, skills, 1 do
		local skillName, skillType, numAvailable, isExpanded = GetTradeSkillInfo(i);
		if ( InvList_ListTypes[skillType] ) then
			-- "header"
			GameTooltip:SetTradeSkillItem(i);
			link=GetTradeSkillItemLink(i);
			_,_,code=string.find(link,"item:(%d+):");
			str = str..format(urlFormat, code, skillName);
		end
	end
	InvListEditBox:SetText(str);
	INVLIST_TEXT = str;
	return true;
end


function InvList_Refresh_Craft()
	local craftName = GetCraftDisplaySkillLine();
	if ( not craftName ) then
		ChatFrame1:AddMessage("InvList: Can not find craft info. Open craft window and try again.", 1, 1, 0);
		HideUIPanel(InvListFrame);
		return false;
	end
	local str = format("[b][u][size=18]%s[/size][/u][/b]\r\n\r\n", UnitName("player").." - "..craftName);
	local urlFormat = "[url=http://wow.allakhazam.com/db/item.html?witem=%d]%s[/url]\r\n";
	local link,code;
	
	local crafts = GetNumCrafts();
	
	for i=1, crafts, 1 do
		local craftName, craftSubSpellName, craftType, numAvailable, isExpanded = GetCraftInfo(i);
		if ( InvList_ListTypes[craftType] ) then
			-- "header"
			GameTooltip:SetCraftSpell(i);
			link=GetCraftItemLink(i);
			_,_,code=string.find(link,"item:(%d+):");
			str = str..format(urlFormat, code, craftName);
		end
	end
	InvListEditBox:SetText(str);
	INVLIST_TEXT = str;
	return true;
end

