--[[
ImprovedMacro v2

Allow you to use more keywords in the macros : 

-- -- -- Names -->

	%pet => Pet Name
	%me, %p1 => Player Name
	%t => Target Name
	%p2 => Party Member 1 Name
	%p3 => Party Member 2 Name
	%p4 => Party Member 3 Name
	%p5 => Party Member 4 Name

-- -- -- Levels -->

	%petl => Pet Level
	%mel, %pl1 => Player Level
	%tl => Target Level
	%pl2 => Party Member 1 Level
	%pl3 => Party Member 2 Level
	%pl4 => Party Member 3 Level
	%pl5 => Party Member 4 Level

Updated by Sinaloit

$Id: ImprovedMacro.lua 1647 2005-05-29 05:48:59Z Sinaloit $
$Rev: 1647 $
$LastChangedBy: Sinaloit $
$Date: 2005-05-29 07:48:59 +0200 (Sun, 29 May 2005) $
]]--

IMPROVEDMACRO_REV = "$Rev: 1647 $";

ImprovedMacroData = {
	equipmentSets = { };
};

ImprovedMacro = {
	replaceVars = function(oldString)
		local newStr = oldString;
		local p0 = UnitName("pet"); if (not UnitName("pet")) then p0 = "<error:p0>" end
		local p1 = UnitName("player"); if (not UnitName("player")) then p1 = "<error:p1>" end
		local p2 = UnitName("party1"); if (not UnitName("party1")) then p2 = "<error:p2>" end
		local p3 = UnitName("party2"); if (not UnitName("party2")) then p3 = "<error:p3>" end
		local p4 = UnitName("party3"); if (not UnitName("party3")) then p4 = "<error:p4>" end
		local p5 = UnitName("party4"); if (not UnitName("party4")) then p5 = "<error:p5>" end
		
		local pl0 = UnitLevel("pet"); if (not UnitLevel("pet")) then pl0 = "<error:p0>" end
		local pl1 = UnitLevel("player"); if (not UnitLevel("player")) then pl1 = "<error:pl1>" end
		local pl2 = UnitLevel("party1"); if (not UnitLevel("party1")) then pl2 = "<error:pl2>" end
		local pl3 = UnitLevel("party2"); if (not UnitLevel("party2")) then pl3 = "<error:pl3>" end
		local pl4 = UnitLevel("party3"); if (not UnitLevel("party3")) then pl4 = "<error:pl4>" end
		local pl5 = UnitLevel("party4"); if (not UnitLevel("party4")) then pl5 = "<error:pl5>" end
		local tl  = UnitLevel("target"); if (not UnitLevel("target")) then tl = "<error:tl>" end

		newStr = string.gsub (newStr, "%%pl0", pl0); -- %pl0
		newStr = string.gsub (newStr, "%%petl", pl0); -- %plet
		newStr = string.gsub (newStr, "%%mel", pl1); -- %mel
		newStr = string.gsub (newStr, "%%pl1", pl1); -- %pl1
		newStr = string.gsub (newStr, "%%pl2", pl2); -- %pl2
		newStr = string.gsub (newStr, "%%pl3", pl3); -- %pl3
		newStr = string.gsub (newStr, "%%pl4", pl4); -- %pl4
		newStr = string.gsub (newStr, "%%pl5", pl5); -- %pl5
		newStr = string.gsub (newStr, "%%tl", tl); -- %tl

		newStr = string.gsub (newStr, "%%p0", p0); -- %p0
		newStr = string.gsub (newStr, "%%pet", p0); -- %pet
		newStr = string.gsub (newStr, "%%me", p1); -- %me
		newStr = string.gsub (newStr, "%%p1", p1); -- %p1
		newStr = string.gsub (newStr, "%%p2", p2); -- %p2
		newStr = string.gsub (newStr, "%%p3", p3); -- %p3
		newStr = string.gsub (newStr, "%%p4", p4); -- %p4
		newStr = string.gsub (newStr, "%%p5", p5); -- %p5

		return newStr;
	end;

	setHooks = function(onOff)
		if (onOff) then
			Sea.util.hook("PaperDollItemSlotButton_OnClick" , "ImprovedMacro_PaperDollItemSlotButton_OnClick", "replace");
			Sea.util.hook("ContainerFrameItemButton_OnClick" , "ImprovedMacro_ContainerFrameItemButton_OnClick", "before");
			Sea.util.hook("ChatFrame_OnEvent" , "ImprovedMacro_ChatFrame_OnEvent", "before");
		else
			Sea.util.unhook("PaperDollItemSlotButton_OnClick" , "ImprovedMacro_PaperDollItemSlotButton_OnClick", "replace");
			Sea.util.unhook("ContainerFrameItemButton_OnClick" , "ImprovedMacro_ContainerFrameItemButton_OnClick", "before");
			Sea.util.unhook("ChatFrame_OnEvent" , "ImprovedMacro_ChatFrame_OnEvent", "before");
		end
	end;

	slashRegister = function()
		if (Sky) then
			Sky.registerSlashCommand(
				{
					id = "ImprovedMacroEquip";
					commands = IMCMD_EQUIP_COMM;
					onExecute = ImprovedMacro.equip;
					helpText = IMCMD_EQUIP_COMM_INFO;
				}
			);
			Sky.registerSlashCommand(
				{
					id = "ImprovedMacroEquipOffhand";
					commands = IMCMD_EQUIP_OH_COMM;
					onExecute = ImprovedMacro.equipOffhand;
					helpText = IMCMD_EQUIP_OH_COMM_INFO;
				}
			);
			Sky.registerSlashCommand(
				{
					id = "ImprovedMacroUnequip";
					commands = IMCMD_UNEQUIP_COMM;
					onExecute = ImprovedMacro.unequip;
					helpText = IMCMD_UNEQUIP_COMM_INFO;
				}
			);
			Sky.registerSlashCommand(
				{
					id = "ImprovedMacroUse";
					commands = IMCMD_USE_COMM;
					onExecute = ImprovedMacro.useItem;
					helpText = IMCMD_EQUIP_COMM_INFO;
				}
			);
			Sky.registerSlashCommand(
				{
					id = "ImprovedMacroUseType";
					commands = IMCMD_USETYPE_COMM;
					onExecute = ImprovedMacro.useItemByType;
					helpText = IMCMD_USE_COMM_INFO;
				}
			);
			Sky.registerSlashCommand(
				{
					id = "ImprovedMacroSaveSet";
					commands = IMCMD_SSET_COMM;
					onExecute = ImprovedMacro.saveSet;
					helpText = IMCMD_SSET_COMM_INFO;
				}
			);
			Sky.registerSlashCommand(
				{
					id = "ImprovedMacroLoadSet";
					commands = IMCMD_LSET_COMM;
					onExecute = ImprovedMacro.loadSet;
					helpText = IMCMD_LSET_COMM_INFO;
				}
			);
		else
			SlashCmdList["EQUIP"] = ImprovedMacro.equip;
			for i = 1, table.getn(IMCMD_EQUIP_COMM) do setglobal("SLASH_EQUIP"..i, IMCMD_EQUIP_COMM[i]);  end

			SlashCmdList["EQUIP_OFFHAND"] = ImprovedMacro.equipOffhand;
			for i = 1, table.getn(IMCMD_EQUIP_OH_COMM) do setglobal("SLASH_EQUIP_OFFHAND"..i, IMCMD_EQUIP_OH_COMM[i]); end

			SlashCmdList["UNEQUIP"] = ImprovedMacro.unequip;
			for i = 1, table.getn(IMCMD_UNEQUIP_COMM) do setglobal("SLASH_UNEQUIP"..i, IMCMD_UNEQUIP_COMM[i]); end

			SlashCmdList["USE"] = ImprovedMacro.useItem;
			for i = 1, table.getn(IMCMD_USE_COMM) do setglobal("SLASH_USE"..i, IMCMD_USE_COMM[i]); end

			SlashCmdList["USETYPE"] = ImprovedMacro.useItemByType;
			for i = 1, table.getn(IMCMD_USETYPE_COMM) do setglobal("SLASH_USETYPE"..i, IMCMD_USETYPE_COMM[i]); end

			SlashCmdList["SSET"] = ImprovedMacro.saveSet;
			for i = 1, table.getn(IMCMD_SSET_COMM) do setglobal("SLASH_SSET"..i, IMCMD_SSET_COMM[i]); end

			SlashCmdList["LSET"] = ImprovedMacro.loadSet;
			for i = 1, table.getn(IMCMD_LSET_COMM) do setglobal("SLASH_LSET"..i, IMCMD_LSET_COMM[i]); end
		end
	end;

	onLoad = function()
		if (convertRev) then
			convertRev("IMPROVEDMACRO_REV");
		end
		ImprovedMacro.setHooks(true);
		ImprovedMacro.slashRegister();
	end;

	getItemNameFromLink = function(itemLink)
		if ((itemLink) and (strlen(itemLink) > 0)) then
			local _, _, itemName = string.find(itemLink, "|c%x+|Hitem:%d+:%d+:%d+:%d+|h%[(.-)%]|h|r");
			return itemName;
		end
		return nil;
	end;

	------------------------------------------
	-- Macros
	------------------------------------------
	getItemName = function(bag, slot)
		local bagNumber, tLink = bag, nil;
		if (type(bagNumber) ~= "number") then
			bagNumber = tonumber(bag);
		end
		if (bagNumber <= -1) then
			tLink = GetInventoryItemLink("player", slot);
		else
			tLink = GetContainerItemLink(bagNumber, slot);
		end
		return ImprovedMacro.getItemNameFromLink(tLink);
	end;

	------------------------------------------
	-- Utility functions
	------------------------------------------
	getCurrentSet = function()
		local table = { };
		for i = 1, 19, 1 do
			table[i] = ImprovedMacro.getItemName(-1, i);
		end
		return table;
	end;

	bagItem = function(usedItems)
		if (not CursorHasItem()) then
			return;
		end
		for i = 0, 4, 1 do
			local numSlot = GetContainerNumSlots(i);
			for y = 1, numSlot, 1 do
				if (not usedItems[i] or not usedItems[i][y]) then
					local texture, itemCount, locked = GetContainerItemInfo(i, y);
					if (not texture) then
						if (not usedItems[i]) then
							usedItems[i] = { };
						end
						usedItems[i][y] = true;
						PickupContainerItem(i,y);
						return;
					end
				end
			end
		end
		Sea.io.error(IMCMD_ERROR_SPACE);
		AutoEquipCursorItem();
	end;

	------------------------------------------
	-- /Commands
	------------------------------------------
	useItem = function(msg, cmd, numberOfTimes)
		if ((not msg) or (strlen(msg) == 0)) then
			Sea.io.print(IMCMD_USE_COMM_INFO);
			return;
		end
		local usedNumberOfTimes = 0;
		--[[ Kinda silly but hey lets not give errors if they try it ]]--
		local itemName = ImprovedMacro.getItemNameFromLink(msg);
		if (itemName) then
			msg = string.upper(itemName);
		else
			msg = string.upper(msg);
		end
		if (not numberOfTimes) then
			numberOfTimes = 1;
		end
		for i = 1, 19, 1 do
			local itemName = ImprovedMacro.getItemName(-1, i);
			if (itemName and strupper(itemName) == msg) then
				UseInventoryItem(i);
				usedNumberOfTimes = usedNumberOfTimes + 1;
				if ( usedNumberOfTimes >= numberOfTimes ) then
					return;
				end
			end
		end
		if (msg and strlen(msg) > 0) then
			for i = 0, 4, 1 do
				local numSlot = GetContainerNumSlots(i);
				for y = 1, numSlot, 1 do
					local itemName = ImprovedMacro.getItemName(i, y);
					if (itemName and strupper(itemName) == msg) then
						UseContainerItem(i, y);
						usedNumberOfTimes = usedNumberOfTimes + 1;
						if ( usedNumberOfTimes >= numberOfTimes ) then
							return;
						end
					end
				end
			end
		end
		Sea.io.error(format(IMCMD_ERROR_UNKITEM, msg));
	end;

	useItemByType = function(msg, cmd, numberOfTimes)
		if ((not msg) or (strlen(msg) == 0)) then
			Sea.io.print(IMCMD_USETYPE_COMM_INFO);
			return;
		end
		local usedNumberOfTimes = 0;
		--[[ Kinda silly but hey lets not give errors if they try it ]]--
		local itemName = ImprovedMacro.getItemNameFromLink(msg);
		if (itemName) then
			msg = string.upper(itemName);
		else
			msg = string.upper(msg);
		end
		if (not numberOfTimes) then
			numberOfTimes = 1;
		end
		if (msg and strlen(msg) > 0) then
			for i = 0, 4, 1 do
				local numSlot = GetContainerNumSlots(i);
				for y = 1, numSlot, 1 do
					classifyData = Sea.wow.item.classifyInventoryItem(i, y) ;
					if (classifyData and (strupper(classifyData.classification) == msg)) then
						UseContainerItem(i, y);
						usedNumberOfTimes = usedNumberOfTimes + 1;
						if ( usedNumberOfTimes >= numberOfTimes ) then
							return;
						end
					end
				end
			end
		end
		Sea.io.error(format(IMCMD_ERROR_NOITEM, msg));
	end;

	saveSet = function(msg)
		msg = tonumber(msg);
		if (msg and msg >= 1 and msg <= 9) then
			local realmName = GetCVar("realmName");
			if (ImprovedMacroData.equipmentSets[realmName] == nil ) then 
				ImprovedMacroData.equipmentSets[realmName] = { };
			end
			local playerName = UnitName("player");
			if (ImprovedMacroData.equipmentSets[realmName][playerName] == nil ) then 
				ImprovedMacroData.equipmentSets[realmName][playerName] = { };
			end
			ImprovedMacroData.equipmentSets[realmName][playerName][msg] = ImprovedMacro.getCurrentSet();
			Sea.io.error(format(IMCMD_ERROR_SAVED, msg));
		else
			Sea.io.print(IMCMD_SSET_COMM_INFO);
		end
	end;

	loadSet = function(msg)
		local realmName, playerName = GetCVar("realmName"), UnitName("player");
		local usedSpaces = { };
		msg = tonumber(msg);
		if (msg and msg >= 1 and msg <= 9) then
			if (not ImprovedMacroData.equipmentSets[realmName][playerName][msg]) then
				Sea.io.error(format(IMCMD_ERROR_UNKSET, msg));
				return;
			end
			if (ImprovedMacroData.equipmentSets[realmName][playerName][msg][16] == ImprovedMacro.getItemName(-1, 17) and
			    ImprovedMacroData.equipmentSets[realmName][playerName][msg][17] ~= ImprovedMacro.getItemName(-1, 16)) then
				PickupInventoryItem(16);
				ImprovedMacro.bagItem(usedSpaces);
				PickupInventoryItem(17);
				PickupInventoryItem(16);
			elseif (ImprovedMacroData.equipmentSets[realmName][playerName][msg][16] == ImprovedMacro.getItemName(-1, 17)) then
				PickupInventoryItem(17);
				PickupInventoryItem(16);
			elseif (ImprovedMacroData.equipmentSets[realmName][playerName][msg][17] == ImprovedMacro.getItemName(-1, 16)) then
				PickupInventoryItem(16);
				PickupInventoryItem(17);
			end

			if (not ImprovedMacroData.equipmentSets[realmName][playerName][msg][17] or ImprovedMacroData.equipmentSets[realmName][playerName][msg][17] == "") then
				PickupInventoryItem(17);
				ImprovedMacro.bagItem(usedSpaces);
			elseif (ImprovedMacroData.equipmentSets[realmName][playerName][msg][17] ~= ImprovedMacro.getItemName(-1, 17)) then
			end

			for i = 1, 19, 1 do
				if (not ImprovedMacroData.equipmentSets[realmName][playerName][msg][i] or ImprovedMacroData.equipmentSets[realmName][playerName][msg][i] == "") then
					PickupInventoryItem(i);
					ImprovedMacro.bagItem(usedSpaces);
				elseif (ImprovedMacroData.equipmentSets[realmName][playerName][msg][i] ~= ImprovedMacro.getItemName(-1, i)) then
					PickupInventoryItem(i);
					ImprovedMacro.bagItem(usedSpaces);
					if (i == 17) then
						ImprovedMacro.equipOffhand(ImprovedMacroData.equipmentSets[realmName][playerName][msg][i], nil, 1);
					else
						ImprovedMacro.equip(ImprovedMacroData.equipmentSets[realmName][playerName][msg][i], nil, 1);
					end
				end
			end
			Sea.io.print(format(IMCMD_ERROR_LOADED, msg));
		else
			Sea.io.print(IMCMD_LSET_COMM_INFO);
		end
	end;

	equip = function(msg, cmd, quiet)
		if (not msg or msg == "") then
			if (not quiet) then
				Sea.io.print(IMCMD_EQUIP_COMM_INFO);
			end
			return;
		end
		if (CursorHasItem()) then
			if (not quiet) then
				Sea.io.error(IMCMD_ERROR_HOLDING);
			end
			return;
		end
		--[[ Kinda silly but hey lets not give errors if they try it ]]--
		local itemName = ImprovedMacro.getItemNameFromLink(msg);
		if (itemName) then
			msg = string.upper(itemName);
		else
			msg = string.upper(msg);
		end
		for i = 0, 4, 1 do
			local numSlot = GetContainerNumSlots(i);
			for y = 1, numSlot, 1 do
				local itemName = ImprovedMacro.getItemName(i, y);
				if (itemName and strupper(itemName) == msg) then
					PickupContainerItem(i,y);
					AutoEquipCursorItem();
					return;
				end
			end
		end

		if (not quiet) then
			Sea.io.error(format(IMCMD_ERROR_UNKITEM, msg));
		end
	end;

	equipOffhand = function(msg, cmd, quiet)
		if (not msg or msg == "") then
			if (not quiet) then
				Sea.io.print(IMCMD_EQUIP_COMM_INFO);
			end
			return;
		end
		if (CursorHasItem()) then
			if (not quiet) then
				Sea.io.error(IMCMD_ERROR_HOLDING);
			end
			return;
		end
		--[[ Kinda silly but hey lets not give errors if they try it ]]--
		local itemName = ImprovedMacro.getItemNameFromLink(msg);
		if (itemName) then
			msg = string.upper(itemName);
		else
			msg = string.upper(msg);
		end
		for i = 0, 4, 1 do
			local numSlot = GetContainerNumSlots(i);
			for y = 1, numSlot, 1 do
				local itemName = ImprovedMacro.getItemName(i, y);
				if (itemName and strupper(itemName) == msg) then
					PickupContainerItem(i,y);
					PickupInventoryItem(17);
					if (CursorHasItem()) then
						PickupContainerItem(i,y);
					end
					return;
				end
			end
		end

		if (not quiet) then
			Sea.io.error(format(IMCMD_ERROR_UNKITEM, msg));
		end
	end;

	unequip = function(msg)
		if (not msg or msg == "") then
			Sea.io.print(IMCMD_UNEQUIP_COMM_INFO);
			return;
		end
		if (CursorHasItem()) then
			Sea.io.error(IMCMD_ERROR_HOLDING);
			return;
		end
		--[[ Kinda silly but hey lets not give errors if they try it ]]--
		local itemName = ImprovedMacro.getItemNameFromLink(msg);
		if (itemName) then
			msg = string.upper(itemName);
		else
			msg = string.upper(msg);
		end
		for i = 1, 19, 1 do
			local itemName = ImprovedMacro.getItemName(-1, i);
			if (itemName and strupper(itemName) == msg) then
				PickupInventoryItem(i);
				ImprovedMacro.bagItem();
				return;
			end
		end
		if (not quiet) then
			Sea.io.error(format(IMCMD_ERROR_UNKITEM, msg));
		end
	end;
};

-----------------------------------------------------------------
--  Hook functions
-----------------------------------------------------------------

function ImprovedMacro_ChatFrame_OnEvent(event)
	if (event == "EXECUTE_CHAT_LINE") then
		arg1 = ImprovedMacro.replaceVars(arg1);
	end
end

function ImprovedMacro_ContainerFrameItemButton_OnClick(button, ignoreShift)
	if (button == "LeftButton") then
		if (IsShiftKeyDown() and not ignoreShift) then
			if (MacroFrame:IsVisible()) then
				local itemLink = GetContainerItemLink(this:GetParent():GetID(), this:GetID());
				local itemName = ImprovedMacro.getItemNameFromLink(itemLink);
				if (itemName) then
					MacroFrame_AddMacroLine(itemName);
				end
			end
		end
	end
end

function ImprovedMacro_PaperDollItemSlotButton_OnClick(button, ignoreShift)
	if (button == "LeftButton") then
		if (IsShiftKeyDown() and not ignoreShift) then
			if (MacroFrame:IsVisible()) then
				local itemLink = GetInventoryItemLink("player", this:GetID());
				local itemName = ImprovedMacro.getItemNameFromLink(itemLink);
				if (itemName) then
					MacroFrame_AddMacroLine(itemName);
				end
				return false;
			end
		end
	end
	return true;
end
