LITTLESKINNER_MAINHAND_SLOT = 16;
LITTLESKINNER_HANDS_SLOT = 10;

LittleSkinner_Options_Default = {
	gloves = nil;
	knife = nil;
};

LittleSkinner_Options = {};

LittleSkinner_OldGloves = nil;
LittleSkinner_OldKnife = nil;

function LittleSkinner_OnLoad()
	local name = "LITTLESKINNER_SKIN";
	SlashCmdList[name] = LittleSkinner_EquipSkinItems;
	for k, v in LITTLESKINNER_CMDS_SKIN do
		setglobal(name..k, v);
	end
	name = "LITTLESKINNER_UNSKIN";
	SlashCmdList[name] = LittleSkinner_UnequipSkinItems;
	for k, v in LITTLESKINNER_CMDS_UNSKIN do
		setglobal(name..k, v);
	end
	name = "LITTLESKINNER_TOGGLE";
	SlashCmdList[name] = LittleSkinner_ToggleSkinItems;
	for k, v in LITTLESKINNER_CMDS_SKINTOGGLE do
		setglobal(name..k, v);
	end
	name = "LITTLESKINNER_KNIFE";
	SlashCmdList[name] = LittleSkinner_SetupKnife;
	for k, v in LITTLESKINNER_CMDS_SKINKNIFE do
		setglobal(name..k, v);
	end
	name = "LITTLESKINNER_GLOVES";
	SlashCmdList[name] = LittleSkinner_SetupGloves;
	for k, v in LITTLESKINNER_CMDS_SKINGLOVES do
		setglobal(name..k, v);
	end
end

function LittleSkinner_Print(msg)
	if ( not DEFAULT_CHAT_FRAME ) then
		return;
	end
	DEFAULT_CHAT_FRAME:AddMessage(msg, 1, 1);
end

function LittleSkinner_ShowUsage()
	for k, v in LITTLESKINNER_CHAT_USAGE do
		LittleSkinner_Print(v);
	end
end

function LittleSkinner_EquipSkinItems(msg)
	if ( msg ) and ( string.find(msg, LITTLESKINNER_CMD_HELP) ) then
		LittleSkinner_ShowUsage();
		return;
	end
	if ( LittleSkinner_Options.gloves ) then
		local itemName = ImprovedMacro.getItemName(-1, LITTLESKINNER_HANDS_SLOT);
		if ( itemName ) then
			itemName = string.upper(itemName);
		end
		if ( not itemName ) or ( itemName ~= LittleSkinner_Options.gloves ) then
			LittleSkinner_OldGloves = itemName;
			ImprovedMacro.equip(LittleSkinner_Options.gloves);
		end
	end
	if ( LittleSkinner_Options.knife ) then
		local itemName = ImprovedMacro.getItemName(-1, LITTLESKINNER_MAINHAND_SLOT);
		if ( itemName ) then
			itemName = string.upper(itemName);
		end
		if ( not itemName ) or ( itemName ~= LittleSkinner_Options.gloves ) then
			LittleSkinner_OldKnife = itemName;
			ImprovedMacro.equip(LittleSkinner_Options.knife);
		end
	end
end

function LittleSkinner_UnequipSkinItems(msg)
	if ( msg ) and ( string.find(msg, LITTLESKINNER_CMD_HELP) ) then
		LittleSkinner_ShowUsage();
		return;
	end
	if ( LittleSkinner_Options.gloves ) and ( LittleSkinner_OldGloves )  then
		local itemName = ImprovedMacro.getItemName(-1, LITTLESKINNER_HANDS_SLOT);
		if ( itemName ) then
			itemName = string.upper(itemName);
		end
		if ( not itemName ) or ( itemName ~= LittleSkinner_OldGloves ) then
			ImprovedMacro.equip(LittleSkinner_OldGloves);
			LittleSkinner_OldGloves = nil;
		end
	end
	if ( LittleSkinner_Options.knife ) then
		local itemName = ImprovedMacro.getItemName(-1, LITTLESKINNER_MAINHAND_SLOT);
		if ( itemName ) then
			itemName = string.upper(itemName);
		end
		if ( not itemName ) or ( itemName ~= LittleSkinner_OldKnife ) then
			ImprovedMacro.equip(LittleSkinner_OldKnife);
			LittleSkinner_OldKnife = nil;
		end
	end
end

function LittleSkinner_ToggleSkinItems(msg)
	if ( msg ) and ( string.find(msg, LITTLESKINNER_CMD_HELP) ) then
		LittleSkinner_ShowUsage();
		return
	end
	local hasGloves = true;
	if ( LittleSkinner_Options.gloves ) then
		local itemName = ImprovedMacro.getItemName(-1, LITTLESKINNER_HANDS_SLOT);
		if ( itemName ) then
			itemName = string.upper(itemName);
		end
		if ( not itemName ) or ( itemName ~= LittleSkinner_Options.gloves ) then
			hasGloves = false;
		end
	end
	local hasKnife = true;
	if ( LittleSkinner_Options.knife ) then
		local itemName = ImprovedMacro.getItemName(-1, LITTLESKINNER_MAINHAND_SLOT);
		if ( itemName ) then
			itemName = string.upper(itemName);
		end
		if ( not itemName ) or ( itemName ~= LittleSkinner_Options.gloves ) then
			hasKnife = false;
		end
	end
	if ( hasGloves ) and ( hasKnife ) then
		if ( LittleSkinner_OldGloves ) then
			ImprovedMacro.equip(LittleSkinner_OldGloves);
			LittleSkinner_OldGloves = nil;
		end
		if ( LittleSkinner_OldKnife ) then
			ImprovedMacro.equip(LittleSkinner_OldKnife);
			LittleSkinner_OldKnife = nil;
		end
	else
		if ( not hasGloves ) and ( LittleSkinner_Options.gloves ) then
			local itemName = ImprovedMacro.getItemName(-1, LITTLESKINNER_HANDS_SLOT);
			if ( itemName ) then
				itemName = string.upper(itemName);
			end
			LittleSkinner_OldGloves = itemName;
			ImprovedMacro.equip(LittleSkinner_Options.gloves);
		end
		if ( not hasKnife ) and ( LittleSkinner_Options.knife ) then
			local itemName = ImprovedMacro.getItemName(-1, LITTLESKINNER_MAINHAND_SLOT);
			if ( itemName ) then
				itemName = string.upper(itemName);
			end
			LittleSkinner_OldKnife = itemName;
			ImprovedMacro.equip(LittleSkinner_Options.knife);
		end
	end
end

function LittleSkinner_SetupKnife(msg)
	local orginalMsg = msg;
	if ( not msg ) or ( string.find(msg, LITTLESKINNER_CMD_HELP) ) or ( strlen(msg) <= 0 ) then
		LittleSkinner_ShowUsage();
		return;
	end
	local itemName = ImprovedMacro.getItemNameFromLink(msg);
	if (itemName) then
		orginalMsg = itemName;
		msg = string.upper(itemName);
	else
		msg = string.upper(msg);
	end
	if ( strlen(msg) <= 0 ) then
		msg = nil;
	else
		for k, v in LITTLESKINNER_PARAM_CLEAR do
			if ( v == msg ) then
				msg = nil;
				break;
			end
		end
	end
	LittleSkinner_Options.knife = msg;
	if ( msg == nil ) then
		msg = LITTLESKINNER_CHAT_CLEARED;
	else
		msg = orginalMsg;
	end
	LittleSkinner_Print(string.format(LITTLESKINNER_CHAT_ITEM_SET, LITTLESKINNER_CHAT_KNIFE, msg));
end

function LittleSkinner_SetupGloves(msg)
	local orginalMsg = msg;
	if ( not msg ) or ( string.find(msg, LITTLESKINNER_CMD_HELP) ) then
		LittleSkinner_ShowUsage();
		return;
	end
	local itemName = ImprovedMacro.getItemNameFromLink(msg);
	if (itemName) then
		orginalMsg = itemName;
		msg = string.upper(itemName);
	else
		msg = string.upper(msg);
	end
	if ( strlen(msg) <= 0 ) then
		msg = nil;
	else
		for k, v in LITTLESKINNER_PARAM_CLEAR do
			if ( v == msg ) then
				msg = nil;
				break;
			end
		end
	end
	LittleSkinner_Options.gloves = msg;
	if ( msg == nil ) then
		msg = LITTLESKINNER_CHAT_CLEARED;
	else
		msg = orginalMsg;
	end
	LittleSkinner_Print(string.format(LITTLESKINNER_CHAT_ITEM_SET, LITTLESKINNER_CHAT_GLOVES, msg));
end
	