ONEHITWONDER_ABILITY_MARK_OF_THE_WILD_NAME = "Mark of the Wild";
ONEHITWONDER_ABILITY_THORNS_NAME = "Thorns";

function OneHitWonder_SetupStuffContinously_Druid()
	OneHitWonder_BuffTime[ONEHITWONDER_ABILITY_MARK_OF_THE_WILD_NAME] = 25*60;
	OneHitWonder_BuffTime[ONEHITWONDER_ABILITY_THORNS_NAME] = 9*60;

	OneHitWonder_AddStuffContinously(ONEHITWONDER_ABILITY_MARK_OF_THE_WILD_NAME, false, true);
	OneHitWonder_AddStuffContinously(ONEHITWONDER_ABILITY_THORNS_NAME, false, true);
end

function OneHitWonder_Druid_Cosmos()
	if ( Cosmos_RegisterConfiguration ) then
		Cosmos_RegisterConfiguration(
			"COS_ONEHITWONDER_DRUID_SEPARATOR",
			"SEPARATOR",
			TEXT(ONEHITWONDER_DRUID_SEPARATOR),
			TEXT(ONEHITWONDER_DRUID_SEPARATOR_INFO)
		);
	end
end

function OneHitWonder_Druid(removeDefense)
	local targetName = UnitName("target");

	if ( not removeDefense ) then removeDefense = false; end
	
	if ( OneHitWonder_ChannelSpellRunning ) then
		return;
	end
	
	if ( (not targetName) or ( strlen(targetName) <= 0 ) ) then
		if ( not OneHitWonder_UseCountermeasures() ) then
			OneHitWonder_DoBuffs();
		end
		return;
	end
	
	if ( not UnitCanAttack("player", "target") ) then
		if ( not OneHitWonder_UseCountermeasures() ) then
			OneHitWonder_DoBuffs();
		end
		return;
	end
	
	if ( OneHitWonder_HandleActionQueue() ) then
		return;
	end

	if ( PlayerFrame.inCombat ~= 1 ) then
		AttackTarget();
	end

	if ( not OneHitWonder_DoBuffs() ) then
		if ( OneHitWonder_CastIfTargetNotHasEffect(ONEHITWONDER_ABILITY_SHOOT, ONEHITWONDER_ABILITY_SHOOT) ) then
			return;
		end
	end
end
