ONEHITWONDER_SPELL_MANA_SHIELD_NAME = "Mana Shield";
ONEHITWONDER_SPELL_FROST_WARD_NAME = "Frost Ward";
ONEHITWONDER_SPELL_FIRE_WARD_NAME = "Fire Ward";

ONEHITWONDER_SPELL_DAMPEN_MAGIC_NAME = "Dampen Magic";

ONEHITWONDER_SPELL_ARCANE_INTELLECT_NAME = "Arcane Intellect";
ONEHITWONDER_SPELL_FROST_ARMOR_NAME = "Frost Armor";
ONEHITWONDER_SPELL_ICE_ARMOR_NAME = "Ice Armor";

OneHitWonder_Mage_ShouldBuffNonCastersIntellect = 0;
OneHitWonder_Mage_ShouldReactiveCastFireWard = 1;
OneHitWonder_Mage_ShouldReactiveCastFrostWard = 1;
OneHitWonder_Mage_ShouldReactiveCastManaShield = 0;

OneHitWonder_Mage_ShouldBuffDampenMagicWhenNoHealer = 0;

OneHitWonder_Mage_ReactiveManaShieldHealthPercentage = 30;
OneHitWonder_Mage_ReactiveManaShieldManaPercentage = 70;

function OneHitWonder_Mage_SetShouldBuffNonCastersIntellect(toggle)
	OneHitWonder_Mage_ShouldBuffNonCastersIntellect = toggle;
end

function OneHitWonder_Mage_SetShouldReactiveCastFireWard(toggle)
	OneHitWonder_Mage_ShouldReactiveCastFireWard = toggle;
end

function OneHitWonder_Mage_SetShouldReactiveCastFrostWard(toggle)
	OneHitWonder_Mage_ShouldReactiveCastFrostWard = toggle;
end

function OneHitWonder_Mage_SetShouldReactiveCastManaShield(toggle)
	OneHitWonder_Mage_ShouldReactiveCastManaShield = toggle;
end

function OneHitWonder_Mage_SetReactiveManaShieldHealthPercentage(toggle, value)
	OneHitWonder_Mage_ReactiveManaShieldHealthPercentage = value;
end

function OneHitWonder_Mage_SetReactiveManaShieldManaPercentage(toggle, value)
	OneHitWonder_Mage_ReactiveManaShieldManaPercentage = value;
end

function OneHitWonder_Mage_SetShouldBuffDampenMagicWhenNoHealer(toggle)
	OneHitWonder_Mage_ShouldBuffDampenMagicWhenNoHealer = toggle;
end

function OneHitWonder_Mage_Cosmos()
	if ( Cosmos_RegisterConfiguration ) then
		Cosmos_RegisterConfiguration(
			"COS_ONEHITWONDER_MAGE_SEPARATOR",
			"SEPARATOR",
			TEXT(ONEHITWONDER_MAGE_SEPARATOR),
			TEXT(ONEHITWONDER_MAGE_SEPARATOR_INFO)
		);
		Cosmos_RegisterConfiguration(
			"COS_ONEHITWONDER_MAGE_BUFF_NON_CASTERS_INTELLECT",
			"CHECKBOX",
			TEXT(ONEHITWONDER_MAGE_BUFF_NON_CASTERS_INTELLECT),
			TEXT(ONEHITWONDER_MAGE_BUFF_NON_CASTERS_INTELLECT_INFO),
			OneHitWonder_Mage_SetShouldBuffNonCastersIntellect,
			OneHitWonder_Mage_ShouldBuffNonCastersIntellect
		);
		Cosmos_RegisterConfiguration(
			"COS_ONEHITWONDER_MAGE_BUFF_DAMPEN_MAGIC_WHEN_NO_HEALERS",
			"CHECKBOX",
			TEXT(ONEHITWONDER_MAGE_BUFF_DAMPEN_MAGIC_WHEN_NO_HEALERS),
			TEXT(ONEHITWONDER_MAGE_BUFF_DAMPEN_MAGIC_WHEN_NO_HEALERS_INFO),
			OneHitWonder_Mage_SetShouldBuffDampenMagicWhenNoHealer,
			OneHitWonder_Mage_ShouldBuffDampenMagicWhenNoHealer
		);
		
		Cosmos_RegisterConfiguration(
			"COS_ONEHITWONDER_MAGE_REACTIVE_CAST_FIRE_WARD",
			"CHECKBOX",
			TEXT(ONEHITWONDER_MAGE_REACTIVE_CAST_FIRE_WARD),
			TEXT(ONEHITWONDER_MAGE_REACTIVE_CAST_FIRE_WARD_INFO),
			OneHitWonder_Mage_SetShouldReactiveCastFireWard,
			OneHitWonder_Mage_ShouldReactiveCastFireWard
		);
		Cosmos_RegisterConfiguration(
			"COS_ONEHITWONDER_MAGE_REACTIVE_CAST_FROST_WARD",
			"CHECKBOX",
			TEXT(ONEHITWONDER_MAGE_REACTIVE_CAST_FROST_WARD),
			TEXT(ONEHITWONDER_MAGE_REACTIVE_CAST_FROST_WARD_INFO),
			OneHitWonder_Mage_SetShouldReactiveCastFrostWard,
			OneHitWonder_Mage_ShouldReactiveCastFrostWard
		);
		Cosmos_RegisterConfiguration(
			"COS_ONEHITWONDER_MAGE_REACTIVE_CAST_MANA_SHIELD",
			"CHECKBOX",
			TEXT(ONEHITWONDER_MAGE_REACTIVE_CAST_MANA_SHIELD),
			TEXT(ONEHITWONDER_MAGE_REACTIVE_CAST_MANA_SHIELD_INFO),
			OneHitWonder_Mage_SetShouldReactiveCastManaShield,
			OneHitWonder_Mage_ShouldReactiveCastManaShield
		);
		Cosmos_RegisterConfiguration(
			"COS_ONEHITWONDER_MAGE_REACTIVE_MANA_SHIELD_HEALTH",
			"SLIDER",
			TEXT(ONEHITWONDER_MAGE_REACTIVE_MANA_SHIELD_HEALTH),
			TEXT(ONEHITWONDER_MAGE_REACTIVE_MANA_SHIELD_HEALTH_INFO),
			OneHitWonder_Mage_SetReactiveManaShieldHealthPercentage,
			1,
			OneHitWonder_Mage_ReactiveManaShieldHealthPercentage,
			0,
			100,
			"",
			1,
			1,
			TEXT(ONEHITWONDER_MAGE_REACTIVE_MANA_SHIELD_HEALTH_APPEND)
		);
		Cosmos_RegisterConfiguration(
			"COS_ONEHITWONDER_MAGE_REACTIVE_MANA_SHIELD_MANA",
			"SLIDER",
			TEXT(ONEHITWONDER_MAGE_REACTIVE_MANA_SHIELD_MANA),
			TEXT(ONEHITWONDER_MAGE_REACTIVE_MANA_SHIELD_MANA_INFO),
			OneHitWonder_Mage_SetReactiveManaShieldManaPercentage,
			1,
			OneHitWonder_Mage_ReactiveManaShieldManaPercentage,
			1,
			100,
			"",
			1,
			1,
			TEXT(ONEHITWONDER_MAGE_REACTIVE_MANA_SHIELD_MANA_APPEND)
		);
	end
end


function OneHitWonder_Mage_SmartPetAttack()
	return OneHitWonder_SmartPetAttack(OneHitWonder_Mage_ShouldPetAttack);
end


function OneHitWonder_SetupStuffContinously_Mage()
	OneHitWonder_BuffTime[ONEHITWONDER_SPELL_ARCANE_INTELLECT_NAME] = 29*60;
	if ( OneHitWonder_Mage_ShouldBuffNonCastersIntellect == 1 ) then
		OneHitWonder_AddStuffContinously(ONEHITWONDER_SPELL_ARCANE_INTELLECT_NAME, false, true);
	else
		OneHitWonder_AddStuffContinously(ONEHITWONDER_SPELL_ARCANE_INTELLECT_NAME, false, true, {onlyBuffClass = OneHitWonder_ManaClassesArray});
	end
	local armorName = ONEHITWONDER_SPELL_ICE_ARMOR_NAME;
	if ( OneHitWonder_GetSpellId(armorName) <= 0 ) then
		armorName = ONEHITWONDER_SPELL_FROST_ARMOR_NAME;
	end
	OneHitWonder_AddStuffContinously(armorName, true, true);
	if ( ( OneHitWonder_Mage_ShouldBuffDampenMagicWhenNoHealer == 1 ) and ( OneHitWonder_GetNumberOfClassInParty(OneHitWonder_HealerClassesArray) <= 0 ) ) then
		OneHitWonder_AddStuffContinously(ONEHITWONDER_SPELL_DAMPEN_MAGIC_NAME, false, true);
	end
end

function OneHitWonder_TryToInterruptSpell_Mage(unitName, spellName)
	local interruptId = -1;
	local abilityName = "";
	if ( OneHitWonder_IsSpellFireBased(spellName) ) then
		abilityName = ONEHITWONDER_SPELL_FIRE_WARD_NAME;
	elseif ( OneHitWonder_IsSpellFrostBased(spellName) ) then
		abilityName = ONEHITWONDER_SPELL_FROST_WARD_NAME;
	end
	if ( ( abilityName ) and 
		(strlen(abilityName) > 0) and ( not OneHitWonder_HasPlayerEffect(nil, abilityName) ) ) then
		interruptId = OneHitWonder_GetSpellId(abilityName);
		if ( OneHitWonder_CheckIfSpellIsCoolingdownById(interruptId) ) then
			abilityName = "";
			interruptId = -1;
		end
	end
	return abilityName, interruptId;
end

function OneHitWonder_Mage_UnitHealthCheck()
	if ( OneHitWonder_Mage_ShouldReactiveCastManaShield == 1 ) then
		local playerHPPercent = OneHitWonder_GetPlayerHPPercentage();
		local playerManaPercent = OneHitWonder_GetPlayerManaPercentage();
		if ( ( playerHPPercent <= OneHitWonder_Mage_ReactiveManaShieldHealthPercentage ) 
			and ( playerManaPercent >= OneHitWonder_Mage_ReactiveManaShieldManaPercentage ) ) then
			local spellId = OneHitWonder_GetSpellId(ONEHITWONDER_SPELL_MANA_SHIELD_NAME);
			if ( ( spellId > -1 ) and ( OneHitWonder_IsSpellAvailable(spellId) ) ) then
				OneHitWonder_AddActionToQueue(ONEHITWONDER_ACTIONID_SPELL_TIMEOUT, { spellId, ( GetTime() + 2) }  );
			end
		end
	end
end


function OneHitWonder_Mage(removeDefense)
	local targetName = UnitName("target");

	if ( not removeDefense ) then removeDefense = false; end
	
	if ( OneHitWonder_ChannelSpellRunning ) then
		return;
	end
	
	if ( (not targetName) or ( strlen(targetName) <= 0 ) ) then
		if ( not OneHitWonder_UseCountermeasures() ) then
			OneHitWonder_DoBuffs();
		end
		return;
	end
	
	if ( not UnitCanAttack("player", "target") ) then
		if ( not OneHitWonder_UseCountermeasures() ) then
			OneHitWonder_DoBuffs();
		end
		return;
	end
	
	if ( OneHitWonder_HandleActionQueue() ) then
		return;
	end

	if ( PlayerFrame.inCombat ~= 1 ) then
		AttackTarget();
	end

	if ( not OneHitWonder_DoBuffs() ) then
		if ( OneHitWonder_CastIfTargetNotHasEffect(ONEHITWONDER_ABILITY_SHOOT, ONEHITWONDER_ABILITY_SHOOT) ) then
			return;
		end
	end
end
