function ScornedDKPGUI_EventHandler(event, p1, p2, p3, p4, p5)
	local obj = nil;
	local frame = ScornedDKPGUIForm;
	local name = frame:GetName();
	if ( event == TSDKP_EVENTS_NEWHIGHESTBID ) then
		ScornedDKPGUI_UpdateBiddingData();
	elseif ( event == TSDKP_EVENTS_BIDOPEN ) then
		frame.item = nil;
		local itemName, itemLink, itemQuality, itemLevel, itemType, itemSubType, itemCount, itemTexture = ScornedDKPGUI_GetItemInfoFromItemLink(p1)
		if ( not itemName ) then
			return;
		end
		obj = getglobal(name.."ItemTexture");
		obj:SetTexture(itemTexture);
		frame.item = p1;
		frame.itemName = itemName;
		frame.itemLink = itemLink;
		frame.itemLevel = itemLevel;
		frame.itemQuality = itemQuality;
		ScornedDKPGUI_UpdateBiddingData();
		frame:Show();
	elseif ( event == TSDKP_EVENTS_CLEARBID ) then
		frame.item = nil;
		frame.itemName = nil;
		frame.itemLink = nil;
		frame.itemLevel = nil;
		frame.itemQuality = nil;
		frame.tooltipText = nil;
		frame:Hide();
	end
end

function ScornedDKPGUI_UpdateBiddingData()
	local highBid, highBidder = TheScornedDKP_System_GetHighestBid();
	local myaccount = TheScornedDKP_System_GetAccountFromPlayer(UnitName("player"));
	local playerPoints = "<UNKNOWN>";
	if ( myaccount ) then
		local data = TheScornedDKP_System_GetAccountData(myaccount);
		if ( data ) and ( data.p ) then
			playerPoints = data.p;
		end
	end
	local pointsText = "";
	if ( highBidder ) then
		local account = TheScornedDKP_System_GetAccountFromPlayer(highBidder);
		local data = TheScornedDKP_System_GetAccountData(account);
		pointsText = format("%d/%d", highBid, data.p)
	else
		highBidder = "Name";
		pointsText = "Points/Max";
	end
	obj = getglobal(name.."LabelName");
	obj:SetText(highBidder);
	obj = getglobal(name.."LabelPoints");
	obj:SetText(pointsText);
	obj = getglobal(name.."LabelPlayerPoints");
	obj:SetText(playerPoints);
	ScornedDKPGUI_UpdateButtons();
end

function ScornedDKPGUI_GetItemInfoFromItemLink(link)
	local itemId = nil;
	if ( type(link) == "string" ) then
		_,_, itemId = string.find(link, "item:(%d+):");
	end
	if ( itemId ) then
		return GetItemInfo(itemId);
	end
end

function ScornedDKPGUI_UpdateButtons()
	local enabled = true;
	local highBid, highBidder = TheScornedDKP_System_GetHighestBid();
	local account = TheScornedDKP_System_GetAccountFromPlayer(highBidder);
	local myaccount = TheScornedDKP_System_GetAccountFromPlayer(UnitName("player"));
	local mydata = TheScornedDKP_System_GetAccountData(myaccount);
	if ( myaccount == account ) then
		enabled = false;
	elseif (mydata.p < highBid ) then
		enabled = false;
	end

	local frame = ScornedDKPGUIForm;
	local name = frame:GetName();
	local obj = getglobal(name.."ButtonBid");
	obj:SetEnabled(enabled);
	obj = getglobal(name.."ButtonPass");
	obj:SetEnabled(enabled);
	
	local admin = TheScornedDKP_System_IsLootMaster();
	obj = getglobal(name.."ButtonWin");
	obj:SetEnabled(admin);
	obj = getglobal(name.."ButtonUndo");
	obj:SetEnabled(admin);
end


function ScornedDKPGUI_OnLoad()
	TheScornedDKP_System_AddEventHandler(ScornedDKPGUI_EventHandler);
	ScornedDKPGUIForm:Hide();
end

function ScornedDKPGUI_Item_OnEnter()
	if ( this.itemName ) and ( this.itemLevel ) and ( this.itemQuality ) then
		this.tooltip = GameTooltip;
		if ( not this.tooltipText ) then
			local color = ITEM_QUALITY_COLORS[this.itemQuality];
			this.tooltipText = format("|c%02x%02x%02xff%s|c L%d", color.r, color.g, color.b, itemName, itemLevel);
		end
		GameTooltip:SetText(this.tooltipText);
		GameTooltip:ClearAllPoints();
		GameTooltip:SetPoint("TOPLEFT", this:GetName().."ItemTexture", "BOTTOMRIGHT");
		GameTooltip:Show();
	end
end

function ScornedDKPGUI_Item_OnLeave()
	if ( this.tooltip ) and ( this.tooltip.Hide ) then
		this.tooltip:Hide();
		this.tooltip = nil;
	end
end


function ScornedDKPGUI_Item_OnClick()
	if ( not this.item ) then
		return;
	end
	if ( this.itemLink ) then
		SetItemRef(this.itemLink);
	end
end

