TheScornedDKP_Data = {
	accounts = {};
	characters = {};
	itemswon = {};
};

TheScornedDKP_Setup = {
	needToSendDKP = false;
	currentBid = {
		item = nil;
		activeBidders = {
		};
		bids = {
		};
	};
	eventHandlers = {};
	verbosity = TSDKP_VERBOSITY_WARNING;
};

function TheScornedDKP_System_Lookup(player)
	local data = TheScornedDKP_System_GetAccountFromPlayer(player);
	if data then
		return data.p;
	end
	return nil;
end

SLASH_DKPLOOKUP1 = "/dkpl";
SlashCmdList["DKPLOOKUP"] = function(msg) local d,s=TheScornedDKP_System_Lookup(msg),""; if d then s="DKP("..msg..") : "..d; else s=msg.." not in list"; end ChatFrame1:AddMessage(s); end

function TheScornedDKP_System_InsertData()
	local accs = {
		Aidelin = 1065;
		Alkin = 1115;
		Amaterasu = 727;
		Saulvin = 1478;
		Amsmoedan = 1129;
		Anomannas = 484;
		Aqsm = 810;
		Azaiel = 791;
		Bamboocha = 637;
		Blaalys = 1547;
		Bogsnifer = 1332;
		Bristo = 460;
		Daligor = 679;
		Danthor = 1165;
		Darness = 1117;
		Darwin = 611;
		Decuriona = 768;
		Dracomar = 1165;
		Dumbledore = 1031;
		Ehlania = 840;
		Esther = 332;
		Gammar = 861;
		Gizmolord = 750;
		Goldielock = 1507;
		Hardic = 1633;
		Harmoni = 925;
		Headbanger = 1095;
		Illdan = 567;
		Janedoe = 1092;
		Kellmar = 1371;
		Kuchinawa = 1382;
		Lapith = 1397;
		Lohrion = 557;
		Luos = 880;
		Macstaverman = 685;
		Melkinas = 1118;
		Misstiger = 244;
		Natura = 467;
		["Orom"] = 1305;
		Pinto = 249;
		Pren = 697;
		Radonir = 1071;
		Rimma = 1245;
		Rodent = 726;
		Rowgeh = 586;
		Scape = 888;
		Sehlenia = 171;
		Shadowbum = 684;
		Shadowleaf = 398;
		Socra = 973;
		Thalissa = 388;
		Thundaga = 689;
		Trilon = 1586;
		Verlian = 562;
		Whizzle = 1174;
		Xtrem = 452;
		Zaratoth = 942;
		Zifer = 899;
		Zoron = 1092;
	};
	local chars = {
		Orochii = Kuchinawa;
		Hobnob = Headbanger;
		Silverlock = Goldielock;
		Decuriona = Decuriona;
		Decurioni = Decuriona;
		Decurione = Decuriona;
		Decurion = Decuriona;
		Deccie = Decuriona;
		Dec = Decuriona;
		Danathor = Danthor;
		Cerwin = Daligor;
		Bogsniffer = Bogsnifer;
		Medicus = Saulvin;
		Amian = Saulvin;
		Sarf = Sarf;
		Pren = Sarf;
		Arfs = Sarf;
		Rafs = Sarf;
		Fars = Sarf;
		Fras = Sarf;
		Hastur = Sarf;
		Whizzle = Whizzle;
		Lohrion = Lohrion;
		Elderwyn = Lohrion;
		Elderwynne = Lohrion;
		Harmoni = Harmoni;
		Ashfall = Harmoni;
		Askia = Harmoni;
	};
	for k, v in accs do TheScornedDKP_System_CreateAccount(k, v); end
	for k, v in accs do TheScornedDKP_Data.characters[k] = k; end
	for k, v in chars do TheScornedDKP_Data.characters[k] = v; end
end


function TheScornedDKP_System_MakeGFindable(str)
	str = string.gsub(str, "%%s", "%(.+%)");
	str = string.gsub(str, "%%d", "%(%%d+%)");
	return str;
end

function TheScornedDKP_System_CreateAccount(player, points)
	if ( TheScornedDKP_Data.accounts[player] ) then
		TheScornedDKP_System_Debug(format("Creation aborted - account already existed for %s.", player));
		return false;
	end
	if ( not points ) then points = TSDKP_STARTING_DKP; end
	TheScornedDKP_System_Debug(format("Creating new account - %s - with %d points.", player, points));
	local t = {};
	t.p = points;
	TheScornedDKP_Data.accounts[player] = t;
	TheScornedDKP_Data.characters[player] = player;
	
	TheScornedDKP_System_Event(TSDKP_EVENTS_DKPUPDATED);
	return true;
end


function TheScornedDKP_System_GetAccountFromPlayer(player)
	if ( not player ) then
		return false;
	end
	if ( TheScornedDKP_Data.accounts[player] ) then
		return player;
	else
		return nil;
	end
end

function OldStuff()
	local account = TheScornedDKP_Data.characters[player];
	if ( account ) then
		return account;
	end
	TheScornedDKP_System_CreateAccount(player);
	return player;
end

function TheScornedDKP_System_HandlePass(player)
	local account = TheScornedDKP_System_GetAccountFromPlayer(player);
	if ( not account ) then
		return;
	end
	TheScornedDKP_Setup.currentBid.activeBidders[account] = false;
	TheScornedDKP_System_Event(TSDKP_EVENTS_PLAYERPASS, account);
end

function TheScornedDKP_System_UndoLastBid(silent)
	local n = table.getn(TheScornedDKP_Setup.currentBid.bids);
	if ( n <= 0 ) then
		TheScornedDKP_System_Warn("No bid to undo.");
		return;
	end
	table.remove(TheScornedDKP_Setup.currentBid.bids, n);
	if ( not silent ) then 
		TheScornedDKP_System_SendToRaid(TSDKP_MSG_UNDO_LAST_BID);
	end
	TheScornedDKP_System_Event(TSDKP_EVENTS_NEWHIGHESTBID);
end


function TheScornedDKP_System_HandleWin(player, silent)
	if ( not player ) then
		TheScornedDKP_System_Critical("A nil player can not win.");
		return;
	end
	local account = TheScornedDKP_System_GetAccountFromPlayer(player);
	if ( not account ) then
		TheScornedDKP_System_Critical("Player not a main.");
		return;
	end
	local highestBidder = nil;
	local highestBid = -1;
	local accountHighBid = -1;
	local accountHighBid, highestBidder = TheScornedDKP_System_GetHighestBid(account);
	if ( accountHighBid <= -1 ) then
		TheScornedDKP_System_Critical(format("%s can not win - no bid registered.", player));
		return;
	end
	local highestBid, highestBidder = TheScornedDKP_System_GetHighestBid();
	if ( highestBid > accountHighBid )  then
		TheScornedDKP_System_Critical(format("%s can not win - not highest bidder (%s).", player, highestBidder));
		return;
	end
	local data = TheScornedDKP_System_GetAccountFromPlayer(account);
	data.p = data.p - highestBid;
	local t = {};
	t.n = account;
	t.c = player;
	t.i = TheScornedDKP_Setup.currentBid.item;
	t.p = highestBid;
	table.insert(TheScornedDKP_Data.itemswon, t);
	
	TheScornedDKP_System_Event(TSDKP_EVENTS_ITEMWON, t);
	if ( not silent ) then 
		TheScornedDKP_System_SendToRaid(format(TSDKP_MSG_ITEM_WON, player, t.i, highestBid));
	end
	TheScornedDKP_System_ClearCurrentBid(true);
	return;
end

function TheScornedDKP_System_ClearCurrentBid(silent)
	TheScornedDKP_Setup.currentBid.item = nil;
	for k, v in pairs(TheScornedDKP_Setup.currentBid.activeBidders) do
		TheScornedDKP_Setup.currentBid.activeBidders[k] = false;
	end
	-- Garbage inducing
	TheScornedDKP_Setup.currentBid.bids = {};
	if ( not silent ) then
		TheScornedDKP_System_SendToRaid(TSDKP_MSG_BID_CLEARED);
	end
	TheScornedDKP_System_Event(TSDKP_EVENTS_CLEARBID);
end

function TheScornedDKP_System_GetHighestBid(player)
	local account = TheScornedDKP_System_GetAccountFromPlayer(player);
	local highestBidder = nil;
	local highestBid = -1;
	local accountHighBid = -1;
	for k, v in pairs(TheScornedDKP_Setup.currentBid.bids) do
		if ( v.p > highestBid ) then 
			highestBid = v.p; 
			highestBidder = v.n;
		end
		if ( account ) and ( v.n == account ) then
			if ( v.p > accountHighBid ) then 
				accountHighBid = v.p; 
			end
		end
	end
	if ( account ) then
		return accountHighBid, player;
	else
		return highestBid, highestBidder;
	end
end

function TheScornedDKP_System_DoPass()
	TheScornedDKP_System_SendChatMessage(TSDKP_MSG_ITEM_PASS, "RAID");
end

function TheScornedDKP_System_GetAccountData(player)
	local account = TheScornedDKP_System_GetAccountFromPlayer(player);
	return TheScornedDKP_Data.accounts[account];
end


function TheScornedDKP_System_DoBid(bid)
	local highestBid, highestBidder = TheScornedDKP_System_GetHighestBid();
	local bidder = UnitName("player");
	local account = TheScornedDKP_System_GetAccountFromPlayer(bidder);
	if ( account == highestBidder ) then
		-- Already highest bidder.
		return false;
	end
	local data = TheScornedDKP_System_GetAccountData(account);
	if ( not bid ) then
		bid = data.p/2+1;
	end
	if ( highestBid > -1 ) then
		if ( data.p < highestBid ) then
			-- Can't match bid.
			return false;
		end
		if ( bid < highestBid ) then
			bid = highestBid + 20;
			if ( bid > data.p ) then
				bid = data.p;
			end
		end
	end
	TheScornedDKP_System_SendChatMessage(format(TSDKP_MSG_ITEM_BID, bid), "RAID");
	return true;
end


function TheScornedDKP_System_HandleBid(player, bid)
	if ( not TheScornedDKP_Setup.currentBid.item ) then
		return false;
	end
	local account = TheScornedDKP_System_GetAccountFromPlayer(player);
	if ( not account ) then
		return false;
	end
	local data = TheScornedDKP_System_Lookup(account);
	if ( not data ) then
		return false;
	end
	if ( data >= bid ) then
		local tmp = data/2+1;
		if ( tmp > bid ) then
			local msg = format("%s has bid too low (%d) - min bid is %d", player, bid, tmp);
			TheScornedDKP_System_Warn(msg);
			TheScornedDKP_System_SendToRaid(msg);
			return;
		end
	else
		local msg = format("%s has bid too many points (%d) - their maximum bid is %d", player, bid, data.p);
		TheScornedDKP_System_Warn(msg);
		TheScornedDKP_System_SendToRaid(msg);
		return;
	end
	local highestBid, highestBidder = TheScornedDKP_System_GetHighestBid();
	if ( highestBid > bid ) then
		local msg = nil;
		if ( highestBid < data.p ) then
			msg = format("%s has bid too few points (%d) - need to bid over %d points.", player, bid, highestBid);
		elseif ( highestBid == data.p ) then
			msg = format("%s has bid too few points (%d) - can precisely match that by going all in (%d points).", player, bid, highestBid);
		else
			msg = format("%s has bid too few points (%d) - can't match current bid (%d).", player, bid, highestBid);
		end
		TheScornedDKP_System_SendToRaid(msg);
		return;
	end
	if ( highestBidder == account ) then
		local msg = format("%s is trying to overbid themselves - bid ignored.", player);
		TheScornedDKP_System_SendToRaid(msg);
		return;
	end
	TheScornedDKP_System_Debug(format("%s has bid %d points", player, bid));
	TheScornedDKP_Setup.currentBid.activeBidders[account] = true;
	local t = {};
	t.n = account;
	t.p = bid;
	table.insert(TheScornedDKP_Setup.currentBid.bids, t);
	
	TheScornedDKP_System_Event(TSDKP_EVENTS_NEWHIGHESTBID, t);
end

function TheScornedDKP_System_Critical(msg)
	TheScornedDKP_System_Message(msg, TSDKP_VERBOSITY_CRITICAL);
end

function TheScornedDKP_System_Notification(msg)
	TheScornedDKP_System_Message(msg, TSDKP_VERBOSITY_NOTIFY);
end

function TheScornedDKP_System_Debug(msg)
	TheScornedDKP_System_Message(msg, TSDKP_VERBOSITY_DEBUG);
end

function TheScornedDKP_System_Warn(msg)
	TheScornedDKP_System_Message(msg, TSDKP_VERBOSITY_WARNING);
end

function TheScornedDKP_System_Message(msg, level)
	if ( TheScornedDKP_Setup.verbosity >= level ) then
		ChatFrame1:AddMessage("TSDKP: "..msg, 1, 1, 0);
	end
end

function TheScornedDKP_System_SendToRaidData(msg)
	if ( TheScornedDKP_System_ShouldSendRaid() ) then
		if ( CT_RA_AddMessage ) then
			CT_RA_AddMessage(msg);
		else
			TheScornedDKP_System_SendChatMessage(msg, "RAID");
		end
	end
end

function TheScornedDKP_System_SendToRaid(msg)
	if ( TheScornedDKP_System_ShouldSendRaid() ) then
		TheScornedDKP_System_SendChatMessage(msg, "RAID");
	end
end

function TheScornedDKP_System_StartBidding(item, extraData, silent)
	if ( not extraData ) then extraData = ""; end
	if ( not item ) then 
		TheScornedDKP_System_Critical("StartBidding called without any item data!");
		return;
	end
	if ( TheScornedDKP_System_NeedToResendDKP() ) and ( not silent ) then 
		TheScornedDKP_System_SendDKPData();
	end
	TheScornedDKP_System_ClearCurrentBid(true);
	TheScornedDKP_Setup.currentBid.item = item;
	if ( not silent ) then
		TheScornedDKP_System_SendToRaid(format(TSDKP_MSG_START_BID, item, extraData));
	end
	TheScornedDKP_System_Event(TSDKP_EVENTS_BIDOPEN, item, extraData);
end

function TheScornedDKP_System_NeedToResendDKP()
	--return TheScornedDKP_Setup.needToSendDKP;
	--return true;
	return false;
end

function TheScornedDKP_System_AddDKPData(data)
	if ( not data ) then
		return;
	end
	local account, data;
	for line in string.gfind(data, "[^\r\n]+") do 
		for name,dkp in string.gfind(line, "(.+)[, ](%d+)") do
			account = TheScornedDKP_System_GetAccountFromPlayer(name);
			data = TheScornedDKP_System_GetAccountData(account)
			if ( data ) then
				data.p = dkp;
			end
		end
	end
	TheScornedDKP_System_Event(TSDKP_EVENTS_DKPUPDATED);
	return true;
end

function TheScornedDKP_System_ReceiveDKPData(data)
	if ( not data ) then
		return false;
	end
	local name, account, adata;
	for name,dkp in string.gfind(data, "(%w+)=(%d+);") do
		account = TheScornedDKP_System_GetAccountFromPlayer(name);
		adata = TheScornedDKP_System_GetAccountData(account);
		if ( adata ) then
			adata.p = dkp;
		end
	end
	TheScornedDKP_System_Event(TSDKP_EVENTS_DKPUPDATED);
	return true;
end

function TheScornedDKP_System_SendDKPData()
	local str = "";
	local account,name;
	for i = 1,GetNumRaidMembers() do
		name = UnitName("unit"..i);
		account = TheScornedDKP_System_GetAccountFromPlayer(name);
		local data = TheScornedDKP_System_GetAccountData(account);
		if ( data ) then
			str = str..format("%s=%d;", name, data.p);
		end
	end
	TheScornedDKP_System_SendToRaidData(str);
	TheScornedDKP_Setup.needToSendDKP = false;
end

function TheScornedDKP_System_AddAccountCharacter(account, character)
	local acc = TheScornedDKP_System_GetAccountFromPlayer(account);
	if ( acc ~= account ) then
		TheScornedDKP_System_Critical("Adding account that evaluates to other account is... not allowed.");
		return;
	end
	if ( account ) and ( character ) and ( TheScornedDKP_Data.characters[character] ~= account ) then
		TheScornedDKP_Data.characters[character] = account;
		TheScornedDKP_System_Debug(format("%s is now an alias/character for %s", character, account));
	end
end

-- used for hooking by the GUI
function TheScornedDKP_System_Event(event, p1, p2, p3, p4, p5)
	for k, v in pairs(TheScornedDKP_Setup.eventHandlers) do
		if ( v ) then
			k(event, p1, p2, p3, p4, p5);
		end
	end
end

function TheScornedDKP_System_AddEventHandler(handler)
	TheScornedDKP_Setup.eventHandlers[handler] = true;
end

function TheScornedDKP_System_RemoveEventHandler(handler)
	TheScornedDKP_Setup.eventHandlers[handler] = false;
end


function TheScornedDKP_System_OnLoad()
	TheScornedDKP_System_MsgHasJoined = TheScornedDKP_System_MakeGFindable(ERR_RAID_MEMBER_ADDED_S);
	TheScornedDKP_System_MsgHasLeft = TheScornedDKP_System_MakeGFindable(ERR_RAID_MEMBER_REMOVED_S);
	local frame = CreateFrame("Frame", "TheScornedDKP_SystemFrame", "nil");
	--frame:RegisterEvent("CHAT_MSG_SYSTEM");
end

function TheScornedDKP_System_OnEvent()	
	if ( event == "CHAT_MSG_SYSTEM" ) then
		local _,_,n = string.find(arg1, TheScornedDKP_System_MsgHasJoined);
		if ( n ) then
			TheScornedDKP_Setup.needToSendDKP = true;
		end
		return;
	end
end


function TheScornedDKP_System_ShouldSendRaid()
	return TheScornedDKP_System_IsLootMaster();
end

function TheScornedDKP_System_IsLootMaster()
	local lootMethod, lootMaster = GetLootMethod();
	if ( lootMaster == 0 ) and ( lootMethod == "master" ) and ((GetNumPartyMembers() > 0) or (GetNumRaidMembers() > 0)) then
		return true;
	else
		return false;
	end
end

function TheScornedDKP_System_ListenToPlayer(player)
	local name, rank, subgroup, level, class, fileName, zone, online, isDead;
	for i = 1, GetNumRaidMembers() do
		name, rank, subgroup, level, class, fileName, zone, online, isDead = GetRaidRosterInfo(i);
		if ( name == player ) and ( rank > 0 ) then
			return true;
		end
	end
end


function TheScornedDKP_System_SendChatMessage(msg, chan, p1, p2, p3)
	--SendChatMessage(msg, chan, p1, p2, p3);
	ChatFrame1:AddMessage("<TSDKP> : "..msg);
end


function TheScornedDKP_System_HandleHelp()
end

TheScornedDKP_System_OnLoad();
