function TheScornedDKP_Chat_OnLoad()
	local frame = CreateFrame("Frame", "TheScornedDKP_ChatFrame");
	frame:SetScript("OnEvent", TheScornedDKP_Chat_OnEvent);
	frame:RegisterEvent("CHAT_MSG_RAID");
	
	TheScornedDKP_Chat_GFindable = {};
	TheScornedDKP_Chat_GFindable[TSDKP_MSG_ITEM_WON] = TheScornedDKP_System_MakeGFindable(TSDKP_MSG_ITEM_WON);
	TheScornedDKP_Chat_GFindable[TSDKP_MSG_START_BID] = TheScornedDKP_System_MakeGFindable(TSDKP_MSG_START_BID);
	
end

function TheScornedDKP_Chat_OnEvent()
	if ( event == "CHAT_MSG_RAID" ) then
		TheScornedDKP_Chat_ParseRaid(arg1, arg2);
		return;
	end
end

function TheScornedDKP_Chat_ParseRaid(msg, player)
	if ( not msg ) then
		ChatFrame1:AddMessage("TSDKP: <ParseRaid> No msg.");
	end
	if ( not player ) then
		ChatFrame1:AddMessage("TSDKP: <ParseRaid> No player.");
	end
	if ( not msg ) or ( not player ) then
		return;
	end
	local lmsg = strlower(msg);
	if ( not lmsg ) then
		ChatFrame1:AddMessage("TSDKP: <ParseRaid> No lmsg.");
	end
	local bid = nil;
	for k, v in pairs(TSDKP_PARSE_PASS) do
		for key, value in pairs(v) do
			if ( lmsg == value ) then
				TheScornedDKP_System_HandlePass(player);
				return;
			end
		end
	end
	for k, v in pairs(TSDKP_PARSE_BID) do
		if ( k == "enUS" ) then
			for key, value in pairs(v) do
				_, _, bid = strfind(lmsg, value);
				if ( bid ) then
					TheScornedDKP_System_HandleBid(player, bid);
					return;
				end
			end
		end
	end
	if ( TheScornedDKP_System_ListenToPlayer(player) ) then
		local _,_, name, item, points = strfind(msg, TheScornedDKP_Chat_GFindable[TSDKP_MSG_ITEM_WON]);
		if ( name ) then 
			TheScornedDKP_System_HandleWin(name, true);
			return;
		elseif ( strfind(msg, TSDKP_MSG_BID_CLEARED) ) then 
			TheScornedDKP_System_ClearCurrentBid(true);
			return;
		elseif ( strfind(msg, TSDKP_MSG_UNDO_LAST_BID) ) then 
			TheScornedDKP_System_UndoLastBid(true);
			return;
		else
			local _,_, item = strfind(msg, TheScornedDKP_Chat_GFindable[TSDKP_MSG_START_BID]);
			-- handle extra data here
			if ( item ) then
				TheScornedDKP_System_StartBidding(item, nil, true);
			else
				TheScornedDKP_System_ReceiveDKPData(msg);
			end
			return;
		end
	end
end


TheScornedDKP_Chat_OnLoad();
