function TheScornedDKP_Slash_OnLoad()
	local cmd = "TSDKP";
	SlashCmdList[cmd] = TheScornedDKP_Slash_Command;
	for k, v in pairs(TSDKP_SLASH_COMMANDS) do
		setglobal("SLASH_"..cmd..k, v);
	end
end

function TheScornedDKP_Slash_Command(msg)
	local cmd = nil;
	_,_,cmd=string.find(msg, "(%w+)");
	if ( not cmd ) then
		TheScornedDKP_Slash_Usage();
		return;
	end
	local lcmd,realCmd;
	lcmd = strlower(cmd);
	for k, v in pairs(TSDKP_COMMANDS) do
		for key, value in pairs(v) do
			if ( lcmd == v ) then
				realCmd = k;
				break;
			end
		end
	end
	if ( not realCmd ) then
		for k, v in pairs(TSDKP_COMMANDS) do
			for key, value in pairs(v) do
				if ( strfind(v, lcmd) ) then
					realCmd = k;
					break;
				end
			end
		end
	end
	if ( not realCmd ) then
		TheScornedDKP_Slash_Usage();
		return;
	elseif ( realCmd == TSDKP_COMMAND_STARTBID ) then
		local i = string.find(msg, "item:");
		if ( i ) then
			local j = string.find(msg, "|h");
			if ( not j ) then j = strlen(msg); end
			local item = strsub(msg, i, j);
			if ( item ) then
				TheScornedDKP_System_StartBidding(item);
			end
		end
	elseif ( realCmd == TSDKP_COMMAND_WIN ) then
		local _,_,name=string.sub(msg, strlen(cmd)+1);
		TheScornedDKP_System_HandleWin(name);
	elseif ( realCmd == TSDKP_COMMAND_CLEARBID ) then
		TheScornedDKP_System_ClearCurrentBid();
	elseif ( realCmd == TSDKP_COMMAND_UNDOLASTBID ) then
		TheScornedDKP_System_UndoLastBid();
	elseif ( realCmd == TSDKP_COMMAND_SENDDKP ) then
		TheScornedDKP_System_SendDKPData();
	end
end

function TheScornedDKP_Slash_Usage()
	for k, v in pairs(TSDKP_SLASH_USAGE) do
		ChatFrame1:AddMessage(v, 1,1,0);
	end
end

TheScornedDKP_Slash_OnLoad();
