ZGAnnounce_Options = {};

local isOnLoad = nil

function ZGAnnounce_OnLoad()
	-- add default values
	for k, v in ZGANNOUNCE_OPTIONS_DEFAULT do
		if ( ZGAnnounce_Options[k] == nil ) then
			ZGAnnounce_Options[k] = v;
		end
	end
	
	local slashCmd = "ZGAnnounce";
	SlashCmdList[slashCmd] = ZGAnnounce_command;
	for k, v in ZGANNOUNCE_SLASH_COMMANDS do
		setglobal("SLASH_"..slashCmd..k, v);
	end
	
	ZGAnnounce_Saved_RollOnLoot = RollOnLoot;
	RollOnLoot = ZGAnnounce_RollOnLoot;
	
	isOnLoad = 1;

	this:RegisterEvent("VARIABLES_LOADED");
	this:RegisterEvent("START_LOOT_ROLL");
end

local function Print(msg)
	if (IOTH_Banner) then
		IOTH_Banner(msg)	
		if (not DEFAULT_CHAT_FRAME) then
			return;
		end
		DEFAULT_CHAT_FRAME:AddMessage(msg);
	else
		if (not DEFAULT_CHAT_FRAME) then
			return;
		end
		DEFAULT_CHAT_FRAME:AddMessage(msg);
	end
end

function ZGAnnounce_OnEvent()
	if (event == "VARIABLES_LOADED") then
		if (isOnLoad == 1) and (ZGAnnounce_Options.enabled) then
			Print(ZGANNOUNCE_MSG_LOADED)
			for k, v in pairs(ZGANNOUNCE_USAGE) do
				DEFAULT_CHAT_FRAME:AddMessage(v);
			end
			isOnLoad = nil;
		end
		-- set default values if options contain nil entries
		for k, v in ZGANNOUNCE_OPTIONS_DEFAULT do
			if ( ZGAnnounce_Options[k] == nil ) then
				ZGAnnounce_Options[k] = v;
			end
		end
		return;
	end
	if ( event == "START_LOOT_ROLL" ) then
		ZGAnnounce_HandleItemRoll(arg1);
		return;
	end
end

function ZGAnnounce_command(msg)
	if (ZGAnnounce_Options.enabled) then
		ZGAnnounce_Options.enabled = false;
		Print(format(ZGANNOUNCE_STATE, ZGANNOUNCE_STATE_DISABLED));
	else
		ZGAnnounce_Options.enabled = true;
		Print(format(ZGANNOUNCE_STATE, ZGANNOUNCE_STATE_ENABLED));
	end
end


function ZGAnnounce_ShouldAnnounce()
	if ( not ZGAnnounce_Options.enabled ) or ( not ZGAnnounce_Options.shouldAnnounce ) then
		return false;
	elseif ( ZGAnnounce_Options.onlyAnnounceIfRaidLeader ) and ( not IsRaidLeader() ) then
		return false;
	elseif ( ZGAnnounce_Options.onlyAnnounceIfRaidOfficer ) and ( ( not IsRaidOfficer() ) and ( not IsRaidLeader() ) ) then
		return false;
	elseif ( ZGAnnounce_Options.onlyInRaid ) and ( GetNumRaidMembers() > 0 ) then
		return false;
	else
		return true;
	end
end

function ZGAnnounce_ShouldRoll(id)
	local name = nil;
	_, name = GetLootRollItemInfo(id);
	return ZGAnnounce_ShouldRollOnItem(name);
end

function ZGAnnounce_ShouldRollOnItem(name)
	if ( ZGAnnounce_Options.onlyInZulGurub ) and ( GetRealZoneText() ~= ZGANNOUNCE_ZONE_ZULGURUB ) then
		return false;
	end
	if ( not name ) then return false; end
	local msg = ZGANNOUNCE_ITEMS[name];
	local class = nil;
	class = UnitClass("player");
	if ( msg ) and (strfind(msg, class)) then
		return true;
	end
	return false;
end

function ZGAnnounce_AQ_Execute(entry)
	if ( not entry.lootIds ) then
		return false;
	end
	local lootId, lootMethod;
	for k, v in entry.lootIds do
		if ( v ) then 
			lootId = k; 
			lootMethod = v;
			break; 
		end
	end
	if ( not lootId ) then
		return false;
	end
	RollOnLoot(lootId, lootMethod);
	entry.lootIds[lootId] = false;
	if ( ZGAnnounce_AQ_ShouldExecute(entry) ) then
		ActionQueue_QueueAction(entry);
	end
	return true;
end

function ZGAnnounce_AQ_ShouldExecute(entry)
	if ( not entry.lootIds ) then
		return false;
	end
	local lootId = nil;
	for k, v in entry.lootIds do
		if ( v ) then 
			return true;
		end
	end
	return false;
end

ZGAnnounce_ActionQueueEntry = {
	id = "ZG Item Need Roll";
	name = "ZG Item Need Roll";
	shouldExecuteFunc = ZGAnnounce_AQ_ShouldExecute;
	executeFunc = ZGAnnounce_AQ_Execute;
	lootIds = {
	};
};

function ZGAnnounce_RollOnLoot(id, rollType, p1, p2, p3, p4, p5)
	if ( ZGAnnounce_ActionQueueEntry.lootIds ) then
		ZGAnnounce_ActionQueueEntry.lootIds[id] = false;
	end
	return ZGAnnounce_Saved_RollOnLoot(id, rollType, p1, p2, p3, p4, p5);
end


function ZGAnnounce_HandleItemRoll(id)
	local name = nil;
	_, name = GetLootRollItemInfo(id);
	if ( ZGAnnounce_ShouldRollOnItem(name) ) then
		RollOnLoot(id, 1);
		ZGAnnounce_ActionQueueEntry.lootIds[id] = 1;
		if ( ActionQueue_QueueAction ) and ( ActionQueue_IsQueued ) and ( not ActionQueue_IsQueued(ZGAnnounce_ActionQueueEntry) ) then 
			ActionQueue_QueueAction(ZGAnnounce_ActionQueueEntry);
		end
	elseif ( name ) and ( ZGANNOUNCE_ITEMS[name] ) then
		RollOnLoot(id, 0);
		ZGAnnounce_ActionQueueEntry.lootIds[id] = 0;
		if ( ActionQueue_QueueAction ) and ( ActionQueue_IsQueued ) and ( not ActionQueue_IsQueued(ZGAnnounce_ActionQueueEntry) ) then 
			ActionQueue_QueueAction(ZGAnnounce_ActionQueueEntry);
		end
	end
	if ( ZGAnnounce_ShouldAnnounce() ) then
		local message = nil;
		if ( name ) then
			message = ZGANNOUNCE_ITEMS[name];
		end
		if ( not message ) and ( ZGAnnounce_Options.announceUnknownItems ) then
			message = ZGANNOUNCE_UNKNOWN_ITEM;
		end
		if ( message ) then 
			SendChatMessage(message, "RAID");
		end
		return true;
	else
		return false;
	end
end